import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import SysWsURL, { completeToken } from 'CONSTS/wsUrlConsts';
import SideControl from './sideControl';
import DataPane from './datapane';
import Explain from './explain';
import RulesLayer from './global/RulesLayer';
import globalMsg from './pagefactory/msgFactory';
import { eventTopics, rulesDataFactory } from './consts';
import LayerPool from './LayerPool';
import TopMsg from './sideControl/TopMsg';

const eventConnect = Connect.eventConnect;

/**
 * 两侧控制区
 *
 * @class MaskContent
 * @extends {Component}
 */
@eventConnect
class MaskContent extends Component {

  componentWillMount() {
    this.setState({ planStarted: this.props.planStarted });
  }

  componentWillReceiveProps  = (nextProps) => {
    this.setState({ planStarted: nextProps.planStarted });
  }

  /**
   * 监控视图消息 (规则 ws)
   */
  handleData = data => {
    console.log('rule ws data:', data);
    const { topic, content } = rulesDataFactory(data);
    if (topic === eventTopics.global_msg) {
      this.props.hiddenScreenSaver();
      globalMsg(content);
      return;
    }
    this.props.trigger(topic, content);
  };

  render() {
    const { planStarted } = this.state;
    const { multiple, onItemClick, layerConfig, showExplain, onExplainClose, alarmStarted, alarmStart, planStart, planQuit } = this.props;

    const wsURL = completeToken(SysWsURL.rulews);
    const controlAnimation = {
      animateName: 'zoom-comb-left',
      visible: !planStarted,
      animateProps: {
        key: 'animate-sidecontrol', // animate key
        transitionAppear: true
      }
    };
    const datapaneAnim = {
      animateName: 'zoom-comb-right',
      visible: !planStarted && !alarmStarted,
      animateProps: {
        key: 'animate-datapane', // animate key
        transitionAppear: true
      }
    };
    const layerPoolAnimation = {
      animateName: 'fade',
      visible: alarmStarted,
      // 设置动画延迟 5 秒
      animateDelay: 5,
      animateProps: {
        key: 'animate-layerPool', // animate key
        transitionAppear: true
      }
    };
    return (
      <div className="mask-content">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <SideControl multiple={multiple} onItemClick={onItemClick} layerConfig={layerConfig} animationProps={controlAnimation} />
        <DataPane animationProps={datapaneAnim} />
        <TopMsg alarmStart={alarmStart} />
        <RulesLayer />
        {alarmStarted && <LayerPool animationProps={layerPoolAnimation} planStart={planStart} planQuit={planQuit} planStarted={planStarted} />}
        <Explain visible={showExplain} onExplainClose={onExplainClose} />
      </div>
    );
  }
}

MaskContent.propTypes = {
  layerConfig: PropTypes.object,
  onItemClick: PropTypes.func,
  // 是否支持多选
  multiple: PropTypes.bool,
  subscribe: PropTypes.func,
  trigger: PropTypes.func,
  showExplain: PropTypes.bool,
  onExplainClose: PropTypes.func,
  hiddenScreenSaver: PropTypes.func,
  planStarted: PropTypes.bool,
  alarmStart: PropTypes.func,
  planStart: PropTypes.func,
  planQuit: PropTypes.func,
  alarmStarted: PropTypes.bool
};

MaskContent.defaultProps = {
  multiple: false
};

export default MaskContent;
