/* eslint-disable no-mixed-operators */
/* eslint-disable no-plusplus */
/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
import { connect3D } from 'amos-3d/lib/designer';
import classNames from 'classnames';

const eventConnect = Connect.eventConnect;

/**
 * 三维告警闪烁
 *
 * @class AlarmMarkerFlicker
 * @extends {Component}
 */
@connect3D
@eventConnect
class AlarmMarkerFlicker extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selected: false
    };
  }

  onClick = (evt) => {
    console.log(evt);
  }

  render() {
    const { type } = this.props;

    // 告警圈样式
    const alarmCls = classNames('marker-alarm-flicker', {
      'flicker-floor-3': type === 'floor_3'
    }, {
      'flicker-floor-6': type === 'floor_6'
    });

    return (
      <div className="container">
        <div className={alarmCls} />
      </div>
    );
  }
}

AlarmMarkerFlicker.propTypes = {
  type: PropTypes.string
};

export default AlarmMarkerFlicker;
