/**
 * 三楼告警点
 */
export const thirdFloor = {
  panel: {
    position: {
      'x': 120.22,
      'y': 69.41,
      'z': 323.20
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_data',
    label: '三楼告警数据',
    type: 'floor_3'
  },
  alarm: {
    position: {
      'x': -86.83,
      'y': 79.12,
      'z': 207.68
      // 'x': 506.93,
      // 'y': 79.12,
      // 'z': 887.09
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_status',
    label: '三楼告警状态',
    type: 'floor_3'
  },
  data: [
    { 'content': 'PM10017 PMTS探测类事件，PMTS未收到应答报文', 'id': 2, 'isAlarm': 1, 'level': '01', 'pointId': 132, 'pointType': '1', 'pointName': 'XAP-P-UPS', 'pointAttrs': { "sourceId": "UPS", "deviceType": "UPS","affiliatedRoom": "中心机房","build": "build_1","position": "349.60,85.69,132.03","storey": "floor_3","affiliatedSystem": "设备" } },
    { 'content': '中心机房-屏蔽间精密空调检测-加湿器故障报警：高线报警！', 'id': 2, 'isAlarm': 1, 'level': '02', 'pointId': 132, 'pointType': '2', 'pointName': 'XAP-P-ECC-SW01.cncc', 'pointAttrs': {"sourceId":"100003","position":"349.60,85.69,132.03","storey":"floor_3","affiliatedSystem":"网管系统" } },
    { 'content': '巡检点0001，检查异常', 'id': 3, 'isAlarm': 1, 'level': '3', 'pointId': 1350, 'pointType': '3', 'pointName': '巡检点0001', 'pointAttrs': {"position":"316.37078537698534,94.28040313720705,120.43478832266285","storey":"floor_3"} }
  ]
};

/**
 * 六楼告警点
 */
export const sixthFloor = {
  panel: {
    position: {
      'x': 338.65,
      'y': 98.03,
      'z': 83.27
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_data',
    label: '六楼告警数据',
    type: 'floor_6'
  },
  alarm: {
    position: {
      'x': 168.65,
      'y': 98.03,
      'z': 83.27
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_status',
    label: '六楼告警状态',
    type: 'floor_6'
  }
};

/**
 * 咸阳告警点
 */
export const xyFloor = {
  panel: {
    position: {
      'x': -260.14,
      'y': 45,
      'z': 468.6
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_data',
    label: '咸阳告警数据',
    type: 'floor_xy'
  },
  alarm: {
    position: {
      'x': -86.83,
      'y': 79.12,
      'z': 207.68
    },
    rotation: {
      'x': 0,
      'y': 0,
      'z': 0
    },
    scale: {
      'x': 1,
      'y': 1,
      'z': 1
    },
    key: 'alarm_status',
    label: '咸阳告警状态',
    type: 'floor_xy'
  }
};

/**
 * 告警点
 */
export const alarmPoint = {
  id: 0,
  key: '',
  level: '',
  objKey: '',
  objType: '02',
  orgCode: null,
  position: '',
  protectObjName: null,
  rate: 0,
  rotation: { x: 0, y: 0, z: 0 },
  scale: { x: 1, y: 1, z: 1 },
  showInfo: false,
  title: '',
  twinkle: true
};
