import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import Search from '../../common/Search';
/**
 * 右侧菜单内容容器
 *
 * @class DataPanelContent
 * @extends {Component}
 */
class DataPanelContent extends Component {

  static propTypes = {
    filter: PropTypes.any,
    searchName: PropTypes.string,
    children: PropTypes.any,
    onFilterChange: PropTypes.func,
    showSearch: PropTypes.bool,
    dataList: PropTypes.array,
    searchType: PropTypes.string,
    searchTextName: PropTypes.string,
    type: PropTypes.string
  };

  static defaultProps = {
    showSearch: true,
    searchName: 'searchValue',
    searchTextName: 'inputText',
    searchType: 'input',
    dataList: [],
    onFilterChange(){}
  };

  constructor(props) {
    super(props);
    this.state = {
      type: ''
    };
  }

  onSearch = (value) => {
    const { searchName, onFilterChange, searchType, searchTextName } = this.props;
    if (searchType === 'selectAndInput') {
      onFilterChange(searchTextName, value, SingleQueryEnum.LIKE);
    } else {
      onFilterChange(searchName, value, SingleQueryEnum.LIKE);
    }
  }

  searchOnChange = (value) => {
    const { searchName, onFilterChange } = this.props;
    this.setState({ type: value });
    onFilterChange(searchName, value, SingleQueryEnum.LIKE);
  }

  render() {
    const { filter, children, showSearch, onFilterChange , searchType, dataList } = this.props;
    const { type } = this.state;
    const Filter = filter ? filter : null;
    return (
      <div className="datapane-container">
        {
          showSearch && <div className="datapanel-search">
            <Search searchOnChange={this.searchOnChange} onSearch={this.onSearch} searchType={searchType} dataList={dataList} />
          </div>
        }
        {
          Filter ?
            <div className="datapane-filter">
              <Filter {...this.props} type={type}  onFilterChange={onFilterChange} />
            </div> : null
        }
        <div className="datapane-content">
          {
            children
          }
        </div>
      </div>
    );
  }
}


export default DataPanelContent;
