import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { Select } from 'amos-framework';
import { DatePicker } from 'amos-antd';

const Option = Select.Option;

const typeList = [
  { id: '01', name: '未读' },
  { id: '02', name: '已读' }
];
const MsgTypeEnum = [{ id: 'protal', name: '巡检' }, { id: 'equiment', name: '设备' }, { id: 'risk', name: '风险' }];

/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func
  };

  constructor(props) {
    super(props);
    this.state = {
      categoryList: []
    };
  }

  componentDidMount() {
    // msgCategoryListAction().then(d => this.setState({ categoryList: d || [] }));
  }

  onFilterChange = (date, dateString) => {
    let searchDate = dateString.split('/').join('-');
    this.props.onFilterChange('time', searchDate, SingleQueryEnum.EQUAL);
  }

  render() {
    const { onFilterChange } = this.props;
    const { categoryList } = this.state;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={MsgTypeEnum}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">类别</Option>}
          onChange={(e) => onFilterChange('category', e, SingleQueryEnum.EQUAL)}
        />
        {/*<Select
          className="datapane-filter-item datapane-filter-select"
          data={typeList}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">所有</Option>}
          onChange={(e) => onFilterChange('type', e, SingleQueryEnum.EQUAL)}
        />*/}
        <DatePicker
          className="datapane-filter-item datapane-filter-date"
          placeholder="时间"
          format="YYYY/MM/DD"
          onChange={this.onFilterChange}
        />
      </div>
    );
  }
}

export default Filter;
