import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select } from 'amos-framework';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { DatePicker } from 'amos-antd';

const Option = Select.Option;
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func,
    statusList: PropTypes.array
  };

  static defaultProps = {
    statusList: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { onFilterChange, statusList } = this.props;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={statusList}
          renderOption={item => <Option className="datapane-select-option" value={item.code}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) =>  onFilterChange('isOK', e, SingleQueryEnum.EQUAL)}
        />
        <DatePicker
          className="datapane-filter-item datapane-filter-date"
          placeholder="时间"
          format="YYYY-MM-DD"
          onChange={(e, s) => onFilterChange('beginDate', s, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }
}

export default Filter;
