import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import { Button } from 'amos-framework';
import imgStatic from 'CONSTS/imgStatic';
import { CONSTS } from 'CONSTS/storageConsts';
import { secExtUrl } from 'CONSTS/urlConsts';
import { tirggerTransTopic } from '../../dataProcessor';
import { getCurrentUser } from 'SERVICES/securityService';
import { getSelectedOrgInfoAction } from 'SERVICES/bizService';

/**
 * 设置-账户设置
 * @class UserSetting
 * @extends {Component}
 */
class UserSetting extends Component {

  static propTypes = {
    logout: PropTypes.func,
    sweepReducers: PropTypes.func,
    write: PropTypes.func,
    toStr: PropTypes.func,
    isLoginout: PropTypes.bool
  };

  static propTypes = {
    logout(){},
    sweepReducers(){},
    write(){},
    toStr(){}
  };

  constructor(props) {
    super(props);
    this.state = {
      user: {}
    };
  }
  componentDidMount() {
    this.onInit();
    this.getSelectedOrgInfo();
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.isLoginout) {
      browserHistory.push('/login');
    }
  }

  onInit = function() {
    getCurrentUser().then(data => {
      let userName = data.realName;
      let departmentInfo = {};
      let companyInfo = {};
      this.setState( { user: { nickName: userName, company: companyInfo, department: departmentInfo } } );
    });
  }

  /**
   * 注销
   */
  onLogOut = () => {
    const { logout, sweepReducers } = this.props;
    tirggerTransTopic(CONSTS.control, { control: { logOut: true } });
    logout && logout(secExtUrl.loginOutUrl);
    sweepReducers && sweepReducers();
    window.localStorage.removeItem('cityLine');
  }

  getSelectedOrgInfo =()=>{
    getSelectedOrgInfoAction().then(data=>{
      const { user } = this.state;
      user.company = data.company;
      user.department = data.department;
      this.setState( { user } );
    });
  }

  render() {
    let { user } = this.state;
 //   const user = currentUser() || {};
    console.log(user);
    return (
      <div className="datapane-setting-user">
        <div className="user-info">
          <p>用户名：{user.nickName}</p>
          <p>公司：{(user.company || {}).companyName}</p>
          <p>部门：{(user.department || {}).departmentName}</p>
          <Button onClick={this.onLogOut}>注销</Button>
        </div>
        <div className="user-img">
          <img src={imgStatic.datapane.user} alt="" />
          {/* <Button>修改图像</Button> */}
        </div>
      </div>
    );
  }
}

export default UserSetting;
