import React from 'react';
import {
  trajectoryAction,
  trajectoryPersonListAction
} from 'SERVICES/3dService';
import imgStatic from 'CONSTS/imgStatic';
import { Button } from 'amos-framework';
import DataPaneBasic from '../common/DataPaneBasic';
import DataPaneContent from '../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from '../common/PaneItem';
import ListPaginate from '../common/ListPaginate';

/**
 * 轨迹
 * @class Trajectory
 * @extends {DataPaneBasic}
 */
class Trajectory extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      filter: [],
      personList: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    trajectoryPersonListAction('user').then(d => this.setState({ personList:  (d || {}).users || [] }));
  }
  /**
   * 点击记录中的一个
   */
  onClick = (item) => {
    window.alert(JSON.stringify(item));
  }

  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    trajectoryAction(filter, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    return [
      { name: '巡检人', value: 'userName' },
      { name: '时间', value: 'checkTime' },
      { name: '轨迹', value: 'traName', render: () => (
        <span className="datapane-prop-value">
          {
            item.traName
          }
          <Button className="trajectory-play-btn" onClick={()=>this.onClick(item)}>
            <img src={imgStatic.datapane.play} alt="" />
            <p>播放</p>
          </Button>
        </span>
      ) }
    ];
  }

  render() {
    const { data, personList, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        personList={personList}
        filter={Filter}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.checkId} data={e} />}
        />
      </DataPaneContent>
    );
  }
}

export default Trajectory;
