export const setPieOption = (seriesdata) => {
  let seriesList = [
    { value: seriesdata.alarmTotal || 0, name: seriesdata.alarmTotal },
    { value: seriesdata.total || 0 , name: seriesdata.total - seriesdata.alarmTotal }
  ];
  let ops = {
    tooltip: {
      trigger: 'item',
      formatter: "{a} <br/>{b}: {c} ({d}%)"
    },
    color:['#FF8000','rgba(88,242,244,0.36)'],
    // legend: {
    //   orient: 'vertical',
    //   x: 'left',
    //   data: ['直接访问','邮件营销','联盟广告','视频广告','搜索引擎']
    // },
    graphic:{
      type:'text',
      left:'center',
      top:'center',
      style:{
          text: seriesdata.num,
          textAlign: 'center',
          fill: '#fff',
          width: 30,
          height: 30
      }
    },
    series: [
      {
        name:'',
        type:'pie',
        radius: ['40%', '60%'],
        avoidLabelOverlap: false,
        hoverOffset: 2,
        label: {
          normal: {
            show: true,
            position: 'right'
          },
          emphasis: {
            show: true,
            textStyle: {
              fontSize: 12
              // fontWeight: 'bold'
            }
          }
        },
        labelLine: {
          normal: {
            show: true,
            length: 6,
            length2: 0
          }
        },
        data: seriesList
      }
    ]
  };
  return ops;
};
export const setLineOption = (seriesdata) => {
  // const { scale } = this.state;
  // let xDatas = Object.keys(seriesdata);
  // let xList = [];
  // if (xDatas[0] && seriesdata[xDatas[0]]) {
  //   xList = seriesdata[xDatas[0]].map(i => i.name);
  // }
  let xList = [];
  let seriesList = [
    [],[]
  ];
  if (seriesdata && seriesdata.data) {
      xList = seriesdata.data.map(i => i.name);
      seriesList[0] = seriesdata.data.map(i => i.normalNum);
      seriesList[1] = seriesdata.data.map(i => i.damageNum);

  }

  console.log(seriesList);
  let ops = {
    // "title": {
    //   "text": "堆叠区域图"
    // },
    "tooltip": {
      "trigger": "axis"
    },
    color: ['#FF0000','#58F458'],
    // "legend": {
    //   "data": [
    //   ]
    // },
    // "toolbox": {
    //   "feature": {
    //     "saveAsImage": {}
    //   }
    // },
    "grid": {
      "left": "6%",
      "right": "6%",
      "bottom": "6%",
      "top": "6%",
      "containLabel": true
    },
    "xAxis": [
      {
        "type": "category",
        axisLine: {
          lineStyle: {
            color: '#5FFFFD'
          }
        },
        axisTick: {
          show: false
        },
        axisLabel: {
          color: '#5FFFFD'
        },
        splitLine: {
          show: true,
          lineStyle: {
            color: '#5FFFFD'
          }
        },
        "boundaryGap": false,
        "data": xList
      }
    ],
    "yAxis": [
      {
        "type": "value",
        axisLine: {
          lineStyle: {
            color: '#5FFFFD'
          }
        },
        axisTick: {
          show: false
        },
        axisLabel: {
          color: '#5FFFFD'
        },
        splitLine: {
          show: true,
          lineStyle: {
            color: '#5FFFFD'
          }
        }
      }
    ],
    "series": [
      {
        "name": "正常",
        "type": "line",
        "stack": "总量",
        // "areaStyle": {
        //   "normal": {}
        // },
        lineStyle: {
          color: '#5FFFFD'
        },
        "data": seriesList[0]
      },
      {
        "name": "异常",
        "type": "line",
        "stack": "总量",
        // "areaStyle": {
        //   "normal": {}
        // },
        "data": seriesList[1]
      }
    ]
  };
  return ops;
};
