import React, { Component } from 'react';
import PropTypes from 'prop-types';
import PickDialog from './PickDialog';

/**
 * 弹出框
 *
 * @class Dialog
 * @extends {Component}
 */
class Dialog extends Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
  }

  onClose = () => {
    this.props.onClose();
  }

  render() {
    const { visible, data } = this.props;
    if (!visible){
      return null;
    }
    return <PickDialog visible pickedPosition={data.pickedPosition} floorType={data.floorType} orgCode={data.orgCode} onClose={this.onClose} />;
  }
}

Dialog.propTypes = {
  data: PropTypes.object,
  visible: PropTypes.bool,
  onClose: PropTypes.func
};

export default Dialog;
