import React,{ Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col, Paragraph } from 'amos-framework';
import imgStatic from 'CONSTS/imgStatic';
import Picture from './Picture';

const pointIcon = imgStatic.planDetail;

class AssistCard extends Component{
  constructor(props) {
    super(props);
    this.state = {
      display: true
    };
  }

  componentWillMount() {
    this.setState({ data: this.props.data });
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ data: nextProps.data });
  }

  onChange = (e) => {
    const { display } = this.state;
    this.setState({ display: !display });
  }

  getListTables = () => {

  }

  render() {
    const { display, data } = this.state;
    let titleStyle = `detailCardTitle-${data.icon}`;
    return (
      <div className="detailCard">
        <div className={titleStyle}>
          <Row className="cardRow">
            <Col span={24} className="cardCol"><img src={pointIcon[data.icon]} className="precontrol-assist-card-img" /><span  title={data.title || ''} className="cardTitleName">{data.title || ''}</span></Col>
          </Row>
        </div>
        <div className={display ? "detailAssistCardContxt" : "detailAssistCardContxt-notDisplay"}>
          { data.image !== '无' && <Picture className="precontro-assist-card-content" markerData={eval(data.image)} />}
          { data.table !== '无' && this.getListTables(data.table)}
          { data.content !== '无' && <Paragraph className="precontro-assist-card-content" html={data.content} />}
        </div>
      </div>
    );
  }
}

AssistCard.propTypes = {
  data: PropTypes.object
};

export default AssistCard;
