/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col, Tabs } from 'amos-framework';
import { dialogDetailsAction } from 'SERVICES/checkService';
import NetworkBaseInfoTab from './equipmentTab/NetworkBaseInfoTab';
import NetworkPortTab from './equipmentTab/NetworkPortTab';
import NetworkWarnTab from './equipmentTab/NetworkWarnTab';
import { dynamicRingData3dAction } from '../../../../../services/3dService';
import AlarmMessage from './dynamicRingDdataInfo/AlarmMessage';
import MonitorElectricity from './dynamicRingDdataInfo/MonitorElectricity';
import OtherInfo from './dynamicRingDdataInfo/OtherInfo';

const { TabList, Tab, TabPanel } = Tabs;

const equipmentStatus = [
  { key: '01', label: '网络设备' },
  { key: '02', label: '服务器' }
];
const networkTabs = [
  { id: '1', closable: false, title: '基本信息' },
  { id: '2', closable: false, title: '端口' },
  { id: '3', closable: false, title: '告警' }
];
const serverTabs = [
  { id: '1', closable: false, title: '常电检测' },
  { id: '2', closable: false, title: '报警信息' },
  { id: '3', closable: false, title: '其他信息' }
];

/**
 * 动环数据
 *
 * @class FireDynamicRingDataModal
 * @extends {Component}
 */
class DynamicRingDataModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      activeKey: '1',
      monitorElectricity: [],
      alarmMessage: [],
      otherInfo: []
    };
  }

  componentDidMount(){
    let { dialogId, objType } = this.props;
    this.queryDynamicRingData(dialogId);
  }

  queryDynamicRingData =(dialogId)=>{
    dynamicRingData3dAction(dialogId).then(data =>{
      let monitorElectricityJson = data.find(e => { return e.equipTempCapabName === '运行参数'}) == undefined ? [] : data.find(e => { return e.equipTempCapabName === '运行参数'}).metricList;
      let alarmMessageJson = data.find(e => { return e.equipTempCapabName === '监测报警'}) == undefined ? [] : data.find(e => { return e.equipTempCapabName === '监测报警'}).metricList;
      let otherInfoJson = data.find(e => { return e.equipTempCapabName === '运行状态'}) == undefined ? [] : data.find(e => { return e.equipTempCapabName === '运行状态'}).metricList;
      this.setState({ 
          // monitorElectricity: monitorElectricityJson != 'null' ? JSON.parse(monitorElectricityJson) : {},
          // alarmMessage: alarmMessageJson != 'null' ? JSON.parse(alarmMessageJson) : {},
          // otherInfo: otherInfoJson != 'null' ? JSON.parse(otherInfoJson) : {},
          monitorElectricity: monitorElectricityJson != 'null' ? monitorElectricityJson : [],
          alarmMessage: alarmMessageJson != 'null' ? alarmMessageJson : [],
          otherInfo: otherInfoJson != 'null' ? otherInfoJson : [],
       });
    });
  }

  onTabClick = (value) => {
    this.setState({ activeKey: value });
  };


  render() {
    const { data, monitorElectricity, alarmMessage, otherInfo, activeKey } = this.state;
    return (
    <div className="dynamicRingData-info">
        <Tabs className='dynamicRingData-info-body' activeKey={activeKey} onChange={(index, key) => this.onTabClick(key)} destroyContent closeAnimate cardMode>
        <TabList>
          {serverTabs.map((item, i) => (
            <Tab key={item.id} activeKey={item.id} closable={item.closable}>
              {item.title}
            </Tab>
          ))}
        </TabList>
        <TabPanel activeKey="1">
          <MonitorElectricity data = {monitorElectricity}/>
        </TabPanel>
        <TabPanel activeKey="2">
          <AlarmMessage data = {alarmMessage}/>
        </TabPanel>
        <TabPanel activeKey="3">
          <OtherInfo data = {otherInfo}/>
        </TabPanel>
      </Tabs>
    </div>
    );
    
  }
}

export default DynamicRingDataModal;
