/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import DynamicRingDataModal from './../dialogModel/DynamicRingDataModal';
import FireDetect from './FireDetect';



/**
 * 动环，火探弹出框
 *
 * @class FireDynamicRingDateModalTable
 * @extends {Component}
 */
class DynamicRingDateModalTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      activeKey: '1'
    };
  }

  componentDidMount() {
    let { dialogId, objType } = this.props;
    //this.queryMarkerDetail(dialogId, objType);
  }


  onTabClick = (value) => {
    this.setState({ activeKey: value });
  };


  render() {
    const { objType, dialogId } = this.props;
    if (objType === '01') {
      return (
        //动环弹出框
        <DynamicRingDataModal type="dynamicRingData" dialogId={dialogId} />
      );
    } else
      if (objType === '02') {
        return (
          <FireDetect dialogId={this.props.dialogId} objType={this.props.objType} />
        );
      }
  }
}


export default DynamicRingDateModalTable;
