/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col, Tabs } from 'amos-framework';
import { dialogDetailsAction } from 'SERVICES/checkService';
import NetworkBaseInfoTab from './equipmentTab/NetworkBaseInfoTab';
import NetworkPortTab from './equipmentTab/NetworkPortTab';
import NetworkWarnTab from './equipmentTab/NetworkWarnTab';
import { impEquDetail3dAction } from '../../../../../services/3dService';
import ServerBaseInfoTab from './equipmentTab/ServerBaseInfoTab';
import ServerInterfaceTab from './equipmentTab/ServerInterfaceTab';

const { TabList, Tab, TabPanel } = Tabs;

const equipmentStatus = [
  { key: '01', label: '网络设备' },
  { key: '02', label: '服务器' }
];
const networkTabs = [
  { id: '1', closable: false, title: '基本信息' },
  { id: '2', closable: false, title: '端口' },
  { id: '3', closable: false, title: '告警' }
];
const serverTabs = [
  { id: '1', closable: false, title: '基本信息' },
  { id: '2', closable: false, title: '网络端口' },
  { id: '3', closable: false, title: '告警' }
];

/**
 * 设备模态框
 *
 * @class FireEquipmentModal
 * @extends {Component}
 */
class EquipmentModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      activeKey: '1'
    };
  }

  componentDidMount(){
    let { dialogId, objType } = this.props;
    this.queryMarkerDetail(dialogId, objType);
  }

  queryMarkerDetail =(dialogId,type)=>{
    impEquDetail3dAction(dialogId,type).then(data =>{
      this.setState({ data });
    });
  }

  onTabClick = (value) => {
    this.setState({ activeKey: value });
  };

  renderNetworkTabs = () => {
    const { activeKey, data } = this.state;
    const { sourceId } = this.props;
    let networkTabsBaseInfo = data.find(e => { return e.equipTempCapabName === 'baseInfo'}) || {};
    return (
      <Tabs className='impEqu-tabs' activeKey={activeKey} onChange={(index, key) => this.onTabClick(key)} destroyContent closeAnimate cardMode>
        <TabList>
          {networkTabs.map((item, i) => (
            <Tab key={item.id} activeKey={item.id} closable={item.closable}>
              {item.title}
            </Tab>
          ))}
        </TabList>
        <TabPanel activeKey="1">
          <NetworkBaseInfoTab equimentId={ this.props.dialogId } data={ networkTabsBaseInfo.metricList }/>
        </TabPanel>
        <TabPanel activeKey="2">
          <NetworkPortTab equimentId={ this.props.dialogId }/>
        </TabPanel>
        <TabPanel activeKey="3">
          <NetworkWarnTab equimentId={ this.props.dialogId } sourceId={ sourceId }/>
        </TabPanel>
      </Tabs>
    );
  }

  renderServerTabs = () => {
    const { activeKey, data } = this.state;
    const { sourceId } = this.props;
    let serverTabsBaseInfo = data.find(e => { return e.equipTempCapabName === 'baseInfo'}) || {};
    let serverNetWorks = data.filter(e => { return e.equipTempCapabName === 'network'}) || [];
    return (
      <Tabs className='impEqu-tabs' activeKey={activeKey} onChange={(index, key) => this.onTabClick(key)} destroyContent closeAnimate cardMode>
        <TabList>
          {serverTabs.map((item, i) => (
            <Tab key={item.id} activeKey={item.id} closable={item.closable}>
              {item.title}
            </Tab>
          ))}
        </TabList>
        <TabPanel activeKey="1">
          <ServerBaseInfoTab equimentId={ this.props.dialogId } data={ serverTabsBaseInfo.metricList }/>
        </TabPanel>
        <TabPanel activeKey="2">
          <ServerInterfaceTab equimentId={ this.props.dialogId } dataList = { serverNetWorks }/>
        </TabPanel>
        <TabPanel activeKey="3">
          <NetworkWarnTab equimentId={ this.props.dialogId } sourceId={ sourceId }/>
        </TabPanel>
      </Tabs>
    );
  }

  render() {
    const { data } = this.state;
    let position = '';

    const { objType } = this.props;
    if(objType === '01'){
      return (
        <div className="impEqu-info">
          { this.renderNetworkTabs() }
        </div>
       );
    }else{
      return (
        <div className="impEqu-info">
          { this.renderServerTabs() }
        </div>
       );
    }
  }
}

export default EquipmentModal;
