import React, { Component } from 'react';
import { Row, Col } from 'amos-framework';
import { dialogDetailsAction } from 'SERVICES/checkService';

/**
 * 数据点模型
 *
 * @class MonitorEquipmentModal
 * @extends {Component}
 */
class MonitorEquipmentModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentDidMount(){
    // eslint-disable-next-line react/prop-types
    let { dialogId, type } = this.props;
    this.queryMarkerDetail(dialogId, type);
  }

  /**
   * 获取标记点详情
   *
   * @memberof MonitorEquipmentModal
   */
  queryMarkerDetail =(dialogId,type)=>{
    dialogDetailsAction(dialogId,type).then(data =>{
      this.setState({ data });
    });
  }

  render() {
    const { data } = this.state;
    let position = '';
    if (Object.keys(data).length > 0){
      position = data.productionArea ? data.productionArea : position;
      position = data.floor3d ? `${position}-${data.floor3d}层` : position;
      position = data.room ? `${position}-${data.room}` : position;
      let begin = position.indexOf('-') >= 0 ? position.indexOf('-') + 1 : 0;
      position = position.substr(begin);
    }
    return (
      <Row className="point-dialog-body">
        <Row className="point-dialog-modal-row">
          <Col className="colTitle">编号：</Col>
          <Col className="colValue">{data.code}</Col>
        </Row>
        <Row className="point-dialog-modal-row">
          <Col className="colTitle">名称：</Col>
          <Col className="colValue">{data.name}</Col>
        </Row>
        <Row className="point-dialog-modal-row">
          <Col className="colTitle">安装位置：</Col>
          <Col className="colValue">{position}</Col>
        </Row>
        <Row className="point-dialog-modal-row">
          <Col className="colTitle">生产厂家：</Col>
          <Col className="colValue">{data.brand}</Col>
        </Row>
        <Row className="point-dialog-modal-row">
          <Col className="colTitle">保护对象：</Col>
          <Col className="colValue">{data.protectObjNames}</Col>
        </Row>
      </Row>
    );
  }
}

export default MonitorEquipmentModal;
