import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { dynamicRingDataDetail3dAction } from '../../../../../../services/3dService';

const bodtCxt = [
    { name: '新风机室内湿度',key: 'indoorHumidity' },
    { name: '新风机室外湿度',key: 'outdoorHumidity' },
    { name: '新风机室内温度',key: 'indoorTemperature' },
    { name: '新风机室外温度',key: 'outdoorTemperature' },
    { name: '送风温度',key: 'blowingInTemperature' },
    { name: '低湿报警值',key: 'lowHumidityAlarmValue', },
    { name: '高湿报警值',key: 'highHumidityAlarmValue', },
    { name: '室内温度上限',key: 'indoorHumidityTopLimit' },
    { name: '送风温度设定',key: 'blowingInTemperatureSet' },
    { name: '室内温度下限',key: 'indoorHumidityLowerLimit' },
    { name: '输入2过热',key: 'indoorTemperatureTopLimit' },
    { name: '输入2频率越限',key: 'indoorTemperatureLowerLimit' },
    { name: '室外温度高限',key: 'outdoorTemperatureHighLimit' },
    { name: '空调启动室内湿度高限',key: 'airConditioningStartIndoorHumidityHighLimit' },
    { name: '空调启动室外温度高限',key: 'airConditioningStartIndoorTemperatureHighLimit' },
    { name: '空调启动室内温度低限',key: 'airConditioningStartIndoorTemperatureLowerLimit' },
    { name: '空调启动室外温度高限',key: 'airConditioningStartOutdoorTemperatureHighLimit' }
  ];

/**
 * 常电检测
 *
 * @class MonitorElectricity
 * @extends {Component}
 */
class MonitorElectricity extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount(){
  }

  render() {
    const { data = [] } = this.props;
    console.log(data)
    return (
        <div className='dynamicRingData-MonitorElectricity'>
            <div className='MonitorElectricity-part1'>

                <Row className="dynamicRingData-baseInfo-row" >
                {data && data.map(item=>{
                return (
                    <div>
                        <Col span={3} className="colTitle">{item.name}：</Col>
                        <Col span={3} className="colValue">{item.value}</Col>
                        </div>
                        );
                    })}
                </Row>
            </div>
        </div>
    );
  }
}

MonitorElectricity.propTypes = {

};

export default MonitorElectricity;
