import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import AmosGridTable from '../../../../../bizview/common/tableComponent/table/AmosGridTable';
import { euqipmentPortInfo3dAction } from '../../../../../../services/3dService';
import { Button } from 'amos-framework';
import BizIcon from './../../../../../../view/common/icon/BizIcon';
import PortDeatilModel from './portDeatilModel';


const listColumns = (self) => {
    return [
        {
        title: '序号',
        render: (text, record, index) => `${index + 1}`,
        width: '6%'
      },
      {
        title: '端口号',
        dataIndex: 'port',
        key: 'port',
        width: '20%'
      },{
        title: '类型',
        dataIndex: 'type',
        key: 'type',
        width: '10%'
      },{
        title: '端口别名',
        dataIndex: 'alias',
        key: 'alias',
        width: '20%'
      },{
        title: '端口从属VLAN',
        dataIndex: 'portVLAN',
        key: 'portVLAN',
        width: '10%'
      },{
        title: '端口带宽',
        dataIndex: 'bandwidth',
        key: 'bandwidth',
        width: '10%'
      },{
        title: '管理状态',
        dataIndex: 'controlStatus',
        key: 'controlStatus',
        
        render: (text, record, index) => {return text === "true" ?<img src = '/src/assets/3dview/controlStatus2.png'/>
                                                                        :<img src = '/src/assets/3dview/controlStatus1.png'/>},
        width: '8%'
      },{
        title: '进流量',
        dataIndex: 'inflow',
        key: 'inflow',
        width: '8%'
      },{
        title: '出流量',
        dataIndex: 'outflow',
        key: 'outflow',
        width: '8%'
      }
    ];
  };

const picArry = ['/src/assets/3dview/port2.png','/src/assets/3dview/port.png'];

/**
 * 网络设备端口
 *
 * @class NetworkPortTab
 * @extends {Component}
 */
class NetworkPortTab extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
        current: 1,
        pageSize: 10
      };
    this.state = {
      data: [],
      gridShow: false,//表格显示
      picShow: true,//图片显示
      curPic: picArry[0],//当前照片
      detailShow: 'none',//悬浮框
      x: '',
      y: '',
    };
  }

  componentDidMount(){
    const { equimentId } = this.props;
    equimentId && this.queryEuqipmentPortInfo(equimentId);
  }

  queryEuqipmentPortInfo =(equimentId)=>{
    euqipmentPortInfo3dAction(equimentId).then(data =>{
      this.setState({ data: data.content });
    });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  /**
   * 分页设置参数
   */
  // setPageConfig = ({ pageSize, current }) => {
  //   if (pageSize !== undefined) {
  //     this.pageConfig.pageSize = pageSize;
  //   }
  //   if (current !== undefined) {
  //     this.pageConfig.pageNumber = current;
  //   }
  // };

  pointClick = (data) =>{
    if(data && data.length != 0){
        this.setState({data:[data[0]]});
    }
  }

  handleMouseOver = (e) =>{
    this.setState({
      detailShow: 'block',
      x: e.pageX, //pageX是以html左上角为原点，相应的clientX是以浏览器左上角为原点
      y: e.pageY,
      })
  }

  handleMouseOut = () =>{
    this.setState({
      detailShow: 'none',
      x: 0,
      y: 0
    })
  }

  onClick = (e, value) => {
    let { gridShow, picShow , curPic } = this.state;
    gridShow = false;
    picShow = false;
    if(value === '3'){
      gridShow = true;
    }else{
      picShow = true;
    }
    if(value === '1'){
      for(var i=0; i < picArry.length;i++){
        if (curPic != picArry[i]){
          curPic = picArry[i];
          break;
        }
      }
    }
    this.setState({ picShow, gridShow, curPic });
  };

  render() {
    const { data, gridShow, picShow, curPic } = this.state;
    return (
        <div className="impEqu-info-table">
            {picShow &&
              <Row >
                <Col span={24} className='imEqu-img-div'>
                    <img className='impEqu-info-img' src={curPic}/>
                    <div className="marker-twinkle" 
                      onClick={()=>this.pointClick(data)}
                      onMouseOver={this.handleMouseOver}
                      onMouseOut={this.handleMouseOut}
                      />
                <PortDeatilModel x={this.state.x} y={this.state.y} detailShow={this.state.detailShow}/>
                </Col>
              </Row>
            }
            {gridShow && 
              <AmosGridTable
                columns={listColumns(this)}
                callBack={this.reload}
                isPageable={false}
                // setPageConfig={this.setPageConfig}
                // defaultPageConfig={this.pageConfig}
                isChecked={false}
                dataList={data || []}
                getTableDataAction={()=>{this.queryEuqipmentPortInfo(this.props.equimentId )}}
              />
            }
            <div className='impEqu-port-button'>
              <Button title="切换" className='port-button'  transparent onClick={e => this.onClick(e, '1')} >
                <img className='button-img' src = '/src/assets/3dview/qiehuan.png'/>
              </Button>
              <Button title="视图" className='port-button'  transparent onClick={e => this.onClick(e, '2')} >
                <img className='button-img' src = '/src/assets/3dview/duankou.png'/>
              </Button>
              <Button title="表格" className='port-button'  transparent onClick={e => this.onClick(e, '3')} >
                <img className='button-img' src = '/src/assets/3dview/biaoge.png'/>
              </Button>
            </div>
        </div>
    );
  }
}

NetworkPortTab.propTypes = {

};

export default NetworkPortTab;
