import { Component } from 'react';
import PropTypes from 'prop-types';
import markerFactory from './markerFactory';
import marker3DFactory from './marker3DFactory';

/**
 * 基本的标记点
 *
 * @class BasicPoint
 * @extends {Component}
 */
class BasicPoint extends Component {
  static propTypes = {
    children: PropTypes.node
  };
  render() {
    return this.props.children;
  }
}

/**
 * 风险
 */
export const RiskPoint = markerFactory(BasicPoint,
  {
    markerType: 'riskSource'
  }
);

/**
 * 巡检
 */
export const PatrolPoint = markerFactory(BasicPoint,
  {
    markerType: 'patrol'
  }
);

/**
 * 人员
 */
export const PersonPoint = markerFactory(BasicPoint,
  {
    markerType: 'person'
  }
);

/**
 * 监控
 */
export const MonitorPoint = markerFactory(BasicPoint,
  {
    markerType: 'video'
  }
);

/**
 * 探测点
 */
export const ProbePoint = markerFactory(BasicPoint,
  {
    markerType: 'monitorEquipment'
  }
);

/**
 * 重点设备
 */
export const EquipmentPoint = markerFactory(BasicPoint,
  {
    markerType: 'impEquipment'
  }
);

/**
 * 动环数据
 */
export const DynamicRingDataPoint = markerFactory(BasicPoint,
  {
    markerType: 'dynamicRingData'
  }
);


/**
 * 人员 3D
 */
export const PersonPoint3D = marker3DFactory(BasicPoint,
  {
    markerType: 'person'
  }
);

/**
 * 消防车 3D
 */
export const FireCar3D = marker3DFactory(BasicPoint,
  {
    markerType: 'fireCar',
    markerParams: {
      useModel: true,
      objPath: '/threeres/marker-models/fire-car.obj',
      mtlPath: '/threeres/marker-models/fire-car.mtl'
    }
  }
);

/**
 * 工人 3D
 */
export const WorkerMen3D = marker3DFactory(BasicPoint,
  {
    markerType: 'workerMen',
    markerParams: {
      useModel: true,
      objPath: '/threeres/marker-models/user/workers.obj',
      mtlPath: '/threeres/marker-models/user/workers.mtl'
    }
  }
);

/**
 * 人员 3D
 */
export const FirePoint = markerFactory(BasicPoint,
  {
    markerType: 'fire'
  }
);

/**
 * 统计
 */
export const PointStatistics = markerFactory(BasicPoint,
  {
    markerType: 'statistics'
  }
);
