import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

/**
 * 统计标记图标
 *
 * @class StatisticsMarkerIcon
 * @extends {Component}
 */
class StatisticsMarkerIcon extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  componentWillMount = () => {

  };

  componentWillReceiveProps = nextProps => {

  };

  renderTitle = statistics => {

    console.log(statistics, 'statistics');

    const style = {
      backgroundColor: 'rgba(0, 98, 157, 0.2)'
    };
    let str = 50 - statistics.statisticsData.length * 10;
    const contentstyle = {
      paddingTop: str + '%'
    };
    if (statistics.statisticsData.length <= 1) {
      return (
        <div className="marker-icon-title" style={style}>
          <div className="title-content">
            {statistics.statisticsData.map(t => {
              return (
                <div key={t} className="title-child">
                  <div className="title-text">{t.count}</div>
                </div>);
            })}
          </div>
        </div>
      );
    }
    return (
      <div className="marker-icon-title" style={style}>
        <div className="title-content" style={contentstyle}>
          {statistics.statisticsData.map(t => {
            return (
              <div key={t} className="title-child">
                <span>{t.name}:</span>
                <div className="title-text">{t.count}</div>
              </div>);
          })}
        </div>
      </div>
    );
  };

  render() {
    const { statistics } = this.props;
    console.log(statistics);
    const style = {
      backgroundSize: 'contain'
    };
    const cls = classNames('marker-statistics-icon', {
      // 'marker-anim': twinkle
    });
    return (
      <div className={cls} style={style}>
        <div className="icon-title" >{statistics.name}</div>
        {this.renderTitle(statistics)}
        <div className="marker-icon-line" />
      </div>
    );
  }
}

StatisticsMarkerIcon.propTypes = {
  statistics: PropTypes.object
};

export default StatisticsMarkerIcon;
