
import { initView3DAction } from 'SERVICES/3dService';
import { getMatchEquipmentListAction } from 'SERVICES/ledgerService';
import { eventTopics } from './consts';
import { desigerHelperConfig } from './conf';

const typeEum = { picture1: '电源负荷图',picture2: '电缆沟封堵图',picture3: '消防车进站行车路线图',picture4: '消防取水图' };
const parseTroubleMarkers = (instance,content,markers)=> {//处理设备报警：切换图层到探测器、显示报警的探测器（闪烁-报警，不闪烁-报警解除）
  const { type, fireEquipmentId: id, equipmentName: title } = content.contingencyRo;//数据结构待定
  const markersArr = markers[type] || [];
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      if (parseInt(ma.id) === parseInt(id)){
        needUpdate = true;
        return {
          ...ma,
          visible: true,//控制点的显示：显示
          showInfo: true,
          title,
          twinkle: true
        };
      } else {
        ma.visible = false;//控制点的显示：不显示
      }
      return ma;
    });
    if (needUpdate){
      markers[type] = newArr;
      instance.setState({
        markers
      });
      instance.setState({
        markers
      });
    }
  }
};

export const  assembleTroubleView = (instance, content, markers)=>{//跳转最佳视角，冒泡显示重点设备名称
  if (void 0 === content || void 0 === content.contingencyRo || void 0 === content.contingencyRo.fireEquipmentPosition) {
    return;
  }
  let equipCameraObj = new Object();
  equipCameraObj.position = content.contingencyRo.fireEquipmentPosition.split(',');
  // instance.cameraFactory.flyTo(equipCameraObj);
  instance.focusPosition(content.contingencyRo.fireEquipmentPosition.split(','));
  const { fireEquipmentId, type = 'monitorEquipment', equipmentId, equipmentName } = content.contingencyRo;//数据结构待定
  const markersArr = markers[type] || [];
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      if (parseInt(ma.id) === parseInt(fireEquipmentId)){
        needUpdate = true;
        return {
          ...ma,
          equipmentId,
          title: equipmentName,
          visible: true,//控制点的显示：显示
          showInfo: true,
          twinkle: false
        };
      }
      return ma;
    });
    if (needUpdate){
      markers[type] = newArr;
      instance.setState({
        markers
      });
    }
  }
};

export const  executorRecord = (instance,content)=>{//右侧按照时间倒叙显示执行记录数据

};

const  dealEquipReleteCameraOpen = (instance,content,markers)=>{//3d显示重点设备配套的摄像头图标及编号
  const { type,cameraIds } = content.contingencyRo;//数据结构待定
  let arry = cameraIds ? cameraIds.split(',') : [];//摄像头数组
  const oldMarkers = instance.state.markers;
  const { monitorEquipment = [] } = oldMarkers || {};
  const markersArr = markers[type] || [];
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      if (arry.some(value => parseInt(value) === parseInt(ma.id))){
        needUpdate = true;
        return {
          ...ma,
          visible: true,//控制点的显示：显示
          showInfo: true//控制显示气泡;显示
        };
      } else {
        ma.visible = false;//控制点的显示：不显示
      }
      return ma;
    });
    if (needUpdate){
      markers[type] = newArr;
      markers['monitorEquipment'] = monitorEquipment;
      instance.setState({
        markers
      });
    }
  }
};

export const  executorRecordConfirm = (instance,content)=>{//右侧按照时间倒叙显示，显示确认着火和消除误报按钮，点击按钮弹出确认或者消除确认弹出消息（具体展示内容、调用后天接口url规则返回）

};

export const  fireIconDisplay = (instance,content)=>{//原来探测器图标替换为着火图标显示
  const { fireEquipmentPosition: position, equipmentId, fireEquipmentId } = content.contingencyRo;//数据结构待定
  let pos = position.split(',');
  let newFire = {
    position: { x: pos.length > 2 ? pos[0] : 0, y: pos.length > 2 ? pos[1] : 0, z: pos.length > 2 ? pos[2] : 0 },
    equipmentId,
    id: fireEquipmentId,
    rotation: { x: 0, y: 0, z: 0 },
    scale: { x: 1, y: 1, z: 1 },
    key: ( Math.ceil(Math.random()*10000000) + ''),
    markerType: 'fire',
    type: 'fire',
    twinkle: true,
    showInfo: false
  };
  const markersArr = instance.state.markers.monitorEquipment || [];
  const newArr = markersArr.map(ma => {
    if (parseInt(ma.id) === parseInt(fireEquipmentId)){
      return {
        ...ma,
        equipmentId,
        visible: false,//控制点的显示：显示
        showInfo: false
      };
    }
    return ma;
  });

  if (void 0 === instance.state.markers.fire) {
    instance.state.markers.fire = [];
  }
  instance.state.markers.fire.push(newFire);
  instance.state.markers.monitorEquipment = newArr;
  // instance.setState({
  //   markers: instance.state.markers
  // });
};

export const  setMinPictureDisPlay = (instance,content, type)=>{//3D界面着火图表上方显示缩略图,点击调用业务屏
  const { equipmentId } = content.contingencyRo;
  const { markers } = instance.state;
  const markersArr = markers.fire || [];
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      if (parseInt(ma.equipmentId) === parseInt(equipmentId)){
        needUpdate = true;
        return {
          ...ma,
          showInfo: true,
          show: type,
          title: typeEum[type],
          url: content.contingencyRo[type] ? content.contingencyRo[type] : ''
        };
      }
      return ma;
    });
    if (needUpdate){
      markers.fire = newArr;
      instance.setState({
        markers
      });
    }
  }
};

export const fireCarDisPlay = (instance, content) => {//3D界面消防车上弹出气泡，显示消防车责任人及电话
  let markers  = {};
  const type = 'fireCar';
  content.contingencyRo.type = type;
  initView3DAction(type).then(d => {
    markers[type] = d;
    parseFireTruckMarkers(instance, content, markers);
  });
};

export const fireCarLineDisPlay = (instance, content) => {//3D界面显示消防车，绘制消防车到达火灾现场行进路线。
  const { fireTruckRoute } = content.contingencyRo;
  showFireTruckRoutePath(instance, fireTruckRoute);
  instance.props.trigger('base3d.fromws1.showFireTruckRoute', { type: 'fireCar', fireTruckRoute });
};

export const  fireDetailBussiness = (instance,content)=>{//火灾详情-----------------页面待定

};

export const  removeFireAlarm = (instance,content)=>{//监控屏报警解除
  const { fireEquipmentId: id } = content.contingencyRo;
  const { markers } = instance.state;
  const type = 'monitorEquipment';
  const markersArr = markers[type] || [];
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      if (parseInt(ma.id) === parseInt(id)){
        needUpdate = true;
        return {
          ...ma,
          visible: true,//控制点的显示：显示
          showInfo: true,//控制气泡信息的显示
          twinkle: false
        };
      } else {
        ma.visible = false;//控制点的显示：不显示
      }
      return ma;
    });
    if (needUpdate){
      markers[type] = newArr;
      markers['patrol'] = [];
      markers['risk'] = [];
      markers['data'] = [];
      markers['room'] = [];
      markers['person'] = [];
      markers['riskSource'] = [];
      markers['impEquipment'] = [];
      markers['dynamicRingData'] = [];
      markers['video'] = [];
      markers['hydrant'] = [];
      markers['pool'] = [];
      markers['fireCar'] = [];
      markers['fireEquipment'] = [];
      markers['fireChamber'] = [];
      markers['fireFoamRoom'] = [];
      instance.setState({
        markers
      });
    }
  }
};

export const removeFireAlarm2 = (instance)=>{//监控屏报警解除
  const { markers } = instance.state;
  markers['monitorEquipment'] = [];
  markers['patrol'] = [];
  markers['risk'] = [];
  markers['data'] = [];
  markers['room'] = [];
  markers['person'] = [];
  markers['riskSource'] = [];
  markers['impEquipment'] = [];
  markers['dynamicRingData'] = [];
  markers['video'] = [];
  markers['hydrant'] = [];
  markers['pool'] = [];
  markers['fireCar'] = [];
  markers['fireEquipment'] = [];
  markers['fireChamber'] = [];
  markers['fireFoamRoom'] = [];
  markers['fireDetection'] = [];
  instance.setState({
    markers
  });
};

export const initView3d = (instance, content) => {//监控屏恢初始状态
  // 1.右侧菜单按钮回复初始-done
  // 2.关闭右侧菜单-done
  // 3.消防车停止移动-done
  instance.props.trigger(eventTopics.view3d_init, {});
  // 4.消防车路线图隐藏-done
  hiddenFireTruckRoute(instance);
  // 5.恢复初始视角
  instance.cameraFactory.fitView(desigerHelperConfig.cameraEffect);
  const { markers } = instance.state;
  markers['monitorEquipment'] = [];
  instance.setState({ markers });
};

export const dealTroubleMarkers = (instance, content) => {
  let markers  = {};
  let type = 'monitorEquipment';
  hiddenFireTruckRoute(instance);
  content.contingencyRo.type = type;
  initView3DAction(type).then(d => {
    markers[type] = d;
    parseTroubleMarkers(instance,content,markers);
  });
};

export const equipReleteCameraOpen = (instance, content) => {
  let markers  = {};
  let type = 'video';
  content.contingencyRo.type = type;
  initView3DAction(type).then(d => {
    markers[type] = d;
    dealEquipReleteCameraOpen(instance,content,markers);
  });
};

export const changeGoodView = (instance, content)=>{
  if (void 0 === content || void 0 === content.contingencyRo) {
    return;
  }
  const equipCameraEffect = {};
  const defaultPosition = '44.23,395.41,296.57';
  const defaultRotation = '-0.93,-0.01,-0.01';
  equipCameraEffect.position = (content.contingencyRo.fireEquipmentPosition || defaultPosition).split(',');
  // equipCameraEffect.rotation = (content.contingencyRo.rotation || defaultRotation).split(',');
  equipCameraEffect.duration = 5000;
  instance.cameraFactory.flyTo(equipCameraEffect);

};

export const matchingFireEquipDisPlay = (instance, content)=>{
  let markers  = {};
  const type  = 'fireResource';
  // content.contingencyRo.type = type ;
  initView3DAction(type).then(d => {
    markers[type] = d;
    markers['hydrant'] = (d['hydrant'] || []).map(item => {return { ...item, visible: true }; });
    markers['pool'] = (d['pool'] || []).map(item => {return { ...item, visible: true }; });
    markers['fireCar'] = (d['fireCar'] || []).map(item => {return { ...item, visible: true }; });
    markers['fireEquipment'] = d['fireEquipment'] || [];
    markers['fireChamber'] = (d['fireChamber'] || []).map(item => {return { ...item, visible: true }; });
    markers['fireFoamRoom'] = (d['fireFoamRoom'] || []).map(item => {return { ...item, visible: true }; });
    parseMatchFireEquipMarkers(instance, content, markers);
  });
};

const parseFireTruckMarkers = (instance, content, markers) => {// 3D界面消防车上弹出气泡，显示消防车责任人及电话
  const { type } = content.contingencyRo;//数据结构待定
  const markersArr = markers[type] || [];
  const oldMarkers = instance.state.markers;
  if (markersArr.length > 0){
    let needUpdate = false;
    const newArr = markersArr.map(ma => {
      needUpdate = true;
      return {
        ...ma,
        visible: true,//控制点的显示：显示
        showInfo: true
      };
    });
    if (needUpdate){
      markers[type] = newArr;
      Object.assign(markers, oldMarkers);
      instance.setState({
        markers
      }, () => fireCarLineDisPlay(instance, content));
    }
  }
};

const parseMatchFireEquipMarkers = (instance, content, markers) => {// 3D界面显示着火重点设备配套的消防设施
  const { equipmentId } = content.contingencyRo;//数据结构待定
  getMatchEquipmentListAction([], equipmentId, -1, -1).then(data => {
    let matchEquipIds = [];
    data.content.map(item => matchEquipIds.push(item.id));
    const markersArr = markers['fireEquipment'] || [];
    const oldMarkers = instance.state.markers;
    if (Object.keys(markers).length > 0){
      const newArr = markersArr.map(ma => {
        if (matchEquipIds.includes(parseInt(ma.id))) {
          return {
            ...ma,
            visible: true,  // 控制点的显示：显示
            showInfo: true
          };
        } else {
          ma.visible = false; //控制点的显示：不显示
        }
        return ma;
      });
      markers['fireEquipment'] = newArr;
      Object.assign(markers, oldMarkers);
      instance.setState({
        markers
      });
    }
  });
};

const showFireTruckRoutePath = (instance, fireTruckRoute) => {
  let pathRoute = [];
  pathRoute.push({ id: 1, linePath: JSON.parse(fireTruckRoute) });
  instance.setState({ showFireTruckRoute: true, pathRoute, fireTruckRoute });
};

const hiddenFireTruckRoute = (instance) => {
  const { showFireTruckRoute } = instance.state;
  showFireTruckRoute ? instance.setState({ showFireTruckRoute: false }) : '';
};
