import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';

/**
 * 饼状图统计
 * @class RiskPointPie
 * @extends {Component}
 */
class RiskPointPie extends Component {
  constructor(props) {
    super(props);
    this.state = {};
  }

  componentWillUnmount() {
    console.log('Component WILL UNMOUNT!');
    let obj = this.echarts.echarts;
    obj.dispose(obj);
  }

  getOptions(obj) {
    let { colors = [] } = obj;
    let name = obj.typeName;
    let count = obj.count;
    return {
      color: colors,
      silent: true,
      series: [
        {
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              position: 'center',
              color: 'white',
              formatter: name + '\r\n\n' + count,
              fontSize: 18,
              lineHeight: 20
            }
          },
          data: obj.data ? obj.data : []
        }
      ]
    };
  }

  getLegend(obj) {
    let array = [];
    if (obj.data) {
      for (let i = 0; i < obj.data.length; i++) {
        let data = obj.data[i];
        let div = (
          <div className="pie-legend-item">
            <div className="pie-legend-item-icon" style={{ width: '11px', height: '17px', background: data.color }} />
            <div className="pie-legend-item-text">
              <pre>
                {data.name}       {data.value}
              </pre>
            </div>
          </div>
        );
        array.push(div);
      }
    }
    return <div className="pie-legend">{array}</div>;
  }

  render() {
    let { data } = this.props;

    let options = this.getOptions(data);
    return (
      <div className="risk-point-pie">
        <div className="risk-point-pie1">
          <AmosEcharts option={options} ref={obj => this.echarts = obj} />
          {this.getLegend(data)}
        </div>
      </div>
    );
  }
}

RiskPointPie.propTypes = {
  data: PropTypes.object
};

RiskPointPie.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default RiskPointPie;
