import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { message } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import { getEmTopoAction,updateEmTopoAction } from './../../../services/equipMonitorService';
import SysWsURL from './../../../consts/wsUrlConsts';
import TopologyComponent from './TopologyComponent';

class EquipMonitor extends Component {
  constructor(props) {
    super(props);
    this.state = {
      topologyData: {} //拓扑图数据
    };
  }

  componentDidMount() {
    this.initTopologyData();
  }

  // 拓扑图数据初始化
  initTopologyData = (value = '') => {
    getEmTopoAction().then(data => {
      if (value === 'refresh') {
        message.success('拓扑图刷新成功!');
      }
      this.setState({
        topologyData: data
      });
    });
  }

  // 保存节点数据
  saveTopologyData = () => {
    const { nodeDataArray,linkDataArray } = this.updateTopologyData;
    const params = {
      nodeData: nodeDataArray,
      linkData: linkDataArray
    };
    updateEmTopoAction(params).then(data => {
      message.success('拓扑图保存成功!');
    });
  }

  // 刷新节点
  refreshTopologyData = () => {
    this.initTopologyData('refresh');
  }

  // 节点数据改变
  nodeChange = (e) => {
    this.updateTopologyData = JSON.parse(e.model.toJson());
  }

  // 选择节点
  nodeSelectionChanged = (e) => {
    // console.log('e',e);
    if (e.isSelected) { }
  }

  // // webSocket 接收消息
  handleData = (data) => {
    console.log(data,'监控设备');
    this.refreshTopologyData();
  }

  render() {
    const { topologyData } = this.state;
    return (
      <div className="equip-monitor-wrapper">
        <AmosWebSocket
          ref={node => this.aws = node}
          url={SysWsURL.sbTopoURI}
          onMessage={this.handleData}
          reconnect
          debug
        />
        <div className="equip-monitor-content">
          <div className="net-topo-header">
            <div className="net-topo-save">
              <img src="/src/assets/bizView/netTopology/save.png" alt="保存"  onClick={this.saveTopologyData} />
            </div>
            <div className="net-topo-refresh">
              <img src="/src/assets/bizView/netTopology/refresh.png" alt="刷新"  onClick={this.refreshTopologyData} />
            </div>
          </div>
          <div className="net-topo-content">
            <TopologyComponent
              topologyData={topologyData}
              nodeChange={this.nodeChange}
              nodeSelectionChanged={this.nodeSelectionChanged}
            />
          </div>
        </div>
      </div>
    );
  }
}

EquipMonitor.propTypes = {

};

export default EquipMonitor;
