import React, { Component } from 'react';
import './../../../../styles/view/biz/monitor/videoLabel.scss';
import LiverPlay from './../../../hikvideo/index';

class RightFour extends Component {

    constructor() {
        super();
    }

    buildVideo = (monitorList, index) => {
        if(monitorList.length > index ){
            return (
                <LiverPlay key={monitorList[index].id} token={monitorList[index].token} vedioId={monitorList[index].id} width="100%" height="100%"/>
            )
        }
    }

    render(){
        let { time, monitorList } = this.props;
        return(
            <div className="monitor-right">   
                <div className="up">
                <div className="left-up">
                    <div className="left-up-content">
                        <div className="left-up-content-top">
                            {/* <span className="img-time">{ time }</span> */}
                            <span className="img-name">{ monitorList.length > 0 ? monitorList[0].name : '' }</span>
                        </div>
                        { this.buildVideo(monitorList, 0) }
                        {/* <iframe src={ monitorList.length > 0 ? monitorList[0].url : ''} scrolling="no" style={{ width:"100%",height:"100%" }} frameBorder="0"></iframe> */}
                    </div>
                </div>
                <div className="right-up">
                    <div className="right-up-content">
                        <div className="right-up-content-top">
                        {/* <span className="img-time">{ time }</span> */}
                        <span className="img-name">{ monitorList.length > 1 ? monitorList[1].name : '' }</span>
                        </div>
                        { this.buildVideo(monitorList, 1) }
                        {/* <iframe src={ monitorList.length > 1 ? monitorList[1].url : ''} scrolling="no" style={{ width:"100%",height:"100%" }} frameBorder="0"></iframe> */}
                    </div>
                </div>
                </div>
                <div className="down">
                <div className="left-down">
                    <div className="left-down-content">
                        <div className="left-down-content-top">
                        {/* <span className="img-time">{ time }</span> */}
                        <span className="img-name">{ monitorList.length > 2 ? monitorList[2].name : '' }</span>
                        </div>
                        { this.buildVideo(monitorList, 2) }
                        {/* <iframe src={ monitorList.length > 2 ? monitorList[2].url : ''} scrolling="no" style={{ width:"100%",height:"100%" }} frameBorder="0"></iframe> */}
                    </div>
                </div>
                <div className="right-down">
                    <div className="right-down-content">
                        <div className="right-down-content-top">
                        {/* <span className="img-time">{ time }</span> */}
                        <span className="img-name">{ monitorList.length > 3 ? monitorList[3].name : '' }</span>
                        </div>
                        { this.buildVideo(monitorList, 3) }
                        {/* <iframe src={ monitorList.length > 3 ? monitorList[3].url : ''} scrolling="no" style={{ width:"100%",height:"100%" }} frameBorder="0"></iframe> */}
                    </div>
                </div>
                </div>   
            </div>
        );
    }
}

export default RightFour;