import React, { Component } from 'react';
import { Table } from 'amos-antd';
import { getARPList } from './../../../../services/pamsTableService';

class ARPTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5,
      ARPList: []
    };
  }

  componentDidMount() {
    this.querryData();
  }

  /**
   * 获取端口数据
   */
  querryData() {
    getARPList('/src/_mock/pamsTable/index.json', ARPList => {
      this.setState({ ARPList });
    });
  }

  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: 'IP地址',
        dataIndex: 'ipAddress',
        key: 'ipAddress',
        width: '5%'
      },
      {
        title: 'MAC地址',
        dataIndex: 'macAddress',
        key: 'macAddress',
        width: '5%'
      }
    ];
  };

  render() {
    const {ARPList } = this.state;
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  false);
    return (
      <div style={{width: '25%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={ARPList} />
      </div>
    );
  }
}

export default ARPTable;
