import React, { Component } from 'react';
import { Row, Col } from 'amos-framework';
import { getEquipmentDetail } from './../../../../services/pamsTableService';

class BasicInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      equipmentDetai: {}
    };
  }
  componentWillMount() {
    this.querryEquipmentDetail(1,'01');
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        name: 'rownum',
        key: 'rownum',
        width: 80
      },
      {
        title: '状态',
        name: 'status',
        key: 'status',
        width: 80
      }
    ];
  };



  /**
   * 获取网络设备数据
   */
  querryEquipmentDetail(id,type){
    getEquipmentDetail(id,type).then(res=>{
      console.log('getEquipmentDetail',res);
      this.setState({
        equipmentDetai: res
      })
    }

    );
  }

  render() {
    console.log('BasicInfo 组建重新加载了');
    const {equipmentDetai } = this.state;
    return (
      <div className="grid-case">
        <Row style={{ width: '1400px' }}>
          <Col xs={{ span: 3}} lg={{ span: 4 }}>
            <div className="pams-table-basicInfo">
              <span className="pams-table-big-weight" style={{fontSize: '12px'}}>设备名称：</span>
              <span>{equipmentDetai.name}</span>
            </div>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>厂商：</span>
            <span>{equipmentDetai.alias}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>当前断通状态：</span>
            <span>{equipmentDetai.status}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>上次轮询时间：</span>
            <span>{equipmentDetai.lastPollingTime}</span>
          </Col>
        </Row>
        <Row style={{ width: '1400px' }}>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <div className="pams-table-basicInfo">
              <span className="pams-table-big-weight" style={{fontSize: '12px'}}>设备编码：</span>
              <span>{equipmentDetai.code}</span>
            </div>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>型号：</span>
            <span>{equipmentDetai.model}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>健康状态：</span>
            <span>{equipmentDetai.healthStatus}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            &nbsp;
          </Col>
        </Row>
        <Row style={{ width: '1400px' }}>
          <Col xs={{ span: 3}} lg={{ span: 4 }}>
            <div className="pams-table-basicInfo">
              <span className="pams-table-big-weight" style={{fontSize: '12px'}}>IP地址：</span>
              <span>{equipmentDetai.ip}</span>
            </div>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>物理位置：</span>
            <span>{equipmentDetai.physicalLocation}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>icmp丢包率：</span>
            <span>{equipmentDetai.packetLossRate}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            &nbsp;
          </Col>
        </Row>
        <Row style={{ width: '1400px' }}>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <div className="pams-table-basicInfo">
              <span className="pams-table-big-weight" style={{fontSize: '12px'}}>IPV6地址</span>
              <span>{equipmentDetai.ipv6}</span>
            </div>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>类型：</span>
            <span>{equipmentDetai.type}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            <span className="pams-table-big-weight" style={{fontSize: '12px'}}>当前警告数：</span>
            <span>{equipmentDetai.type}</span>
          </Col>
          <Col xs={{ span: 3 }} lg={{ span: 4 }}>
            &nbsp;
          </Col>
        </Row>
      </div>
    );
  }
}

export default BasicInfo;
