import React, { Component } from 'react';
import CpuUsageRate from './cpuUsageRate';
import RamUsageRate from './ramUsageRate';
import RamCombination from './ramCombination';

const resourceData = {
  cpuRate: '53% 2.91GHz',
  L1Caching: '256KB',
  L2Caching: '1.0M',
  L3Caching: '6.0M'
};
const caChingData = {
  cachingRate: '44% 5.2/11.9GB',
  virtualCaching: '44% 5.2/11.9GB'
};

class EquipResource extends Component {
  constructor(props) {
    super(props);
    this.state = {};
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        name: 'rownum',
        key: 'rownum',
        width: 80
      },
      {
        title: '状态',
        name: 'status',
        key: 'status',
        width: 80
      }
    ];
  };
  render() {
    console.log('EquipResource 组建重新加载了');
    return (
      <div style={{ marginLeft: '44px' }}>
        <div className="pams-table-equipResource-div">
          <div className="pams-table-equipResource">
            <div style={{ float: 'left' }} className="pams-table-big-weight">
              <span>CPU使用率：</span>
            </div>
            <div style={{ float: 'left', width: '100px', height: '100%' }}>
              <span>{resourceData.cpuRate}</span>
            </div>
          </div>
          <div className="pams-table-equipResource">
            <span className="pams-table-big-weight">L1缓存：</span>
            <span>{resourceData.L1Caching}</span>
          </div>
          <div className="pams-table-equipResource">
            <span className="pams-table-big-weight">L2缓存：</span>
            <span>{resourceData.L2Caching}</span>
          </div>
          <div className="pams-table-equipResource">
            <span className="pams-table-big-weight">L3缓存：</span>
            <span>{resourceData.L3Caching}</span>
          </div>
        </div>
        <div className="pams-table-equipResource-chart">
          <div style={{}}>
            <span style={{ fontSize: '12' }} className="pams-table-big-weight">
              CPU
            </span>
            <span className="pams-table-equipResource-smallFont" style={{ marginLeft: '136px' }}>
              inter(R) Core(TM) i5-6400 CPU @ 2.7Ghz
            </span>
          </div>
          <div style={{marginTop: '25px'}}>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight pams-table-samll-weight" style={{ float: 'left' }}>
              %利用率
            </span>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight" style={{ float: 'right' }}>
              100%
            </span>
          </div>
          <CpuUsageRate />
          <div style={{marginTop: '15px'}}>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight">60秒</span>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight" style={{ float: 'right' }}>
              0
            </span>
          </div>
        </div>
        <div className="pams-table-equipResource-div" style={{ marginLeft: '40px' }}>
          <div className="pams-table-equipResource">
            <div style={{float:'left',width:'65px'}}>
              <span className="pams-table-big-weight">物理内存使用率：</span>
            </div>
            <div>
              <span style={{maringLeft: '20px'}}>{caChingData.cachingRate}</span>
            </div>
          </div>
          <div className="pams-table-equipResource">
            <div style={{float:'left',width:'65px'}}>
              <span className="pams-table-big-weight">虚拟内存使用率：</span>
            </div>
            <div>
              <span style={{maringLeft: '20px'}}>{caChingData.virtualCaching}</span>
            </div>
          </div>
        </div>
        <div className="pams-table-equipResource-cachingDiv">
          <div>
            <span className="pams-table-big-weight">内存</span>
            <span className="pams-table-equipResource-smallFont" style={{ marginLeft: '340px' }}>
              12GB
            </span>
          </div>
          <div>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight" style={{ float: 'left' }}>
              内存使用量
            </span>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight" style={{ float: 'right' }}>
              11.9GB
            </span>
          </div>
          <div className="pams-table-equipResource-ramRatechart">
            <RamUsageRate />
          </div>
          <div>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight">60秒</span>
            <span className="pams-table-equipResource-smallFont" style={{ float: 'right' }}>
              0
            </span>
          </div>
          <div>
            <span className="pams-table-equipResource-smallFont pams-table-samll-weight" style={{ float: 'left' }}>
              内存组合
            </span>
          </div>
          <div className="pams-table-equipResource-ramCombinechart">
            <RamCombination />
          </div>
        </div>
      </div>
    );
  }
}

export default EquipResource;
