import React, { Component } from 'react';
import { Table, Col, Row, Pagination } from 'amos-antd';
import { Search, Icon } from 'amos-framework';
import './../../../../styles/view/biz/situation/warn.scss';
import { getWarningsData, getWarningsByPageData, getWarningsExcelData } from 'SERVICES/situationService';
import AmosWebSocket from 'amos-websocket';
import SysWsURL, { completeToken } from 'CONSTS/wsUrlConsts';

//页面列表
const columnss = () => [
  { title: '设备编号', dataIndex: 'sourceId', key: "sourceId", width: '6%' },
  {
    title: '严重度', dataIndex: 'alarmLevel', key: "alarmLevel", width: '6%',
    render: (text, record) => {
      if (text === '紧急告警') {
        return <div className='urgency'><span>{text}</span></div>
      } else if (text === '次要告警') {
        return <div className='minor'><span>{text}</span></div>
      } else if (text === '警告告警') {
        return <div className='slight'><span>{text}</span></div>
      } else if (text === '重要告警') {
        return <div className='significance'><span>{text}</span></div>
      } else {
        return <div ><span>{text}</span></div>
      }
    }
  },
  { title: "告警原因", dataIndex: "alarmReason", key: "alarmReason", width: "14%" },
  { title: "告警源IP", dataIndex: "alarmSourceIp", key: "alarmSourceIp", width: "7%" },
  { title: "告警源名称", dataIndex: "alarmSourceName", key: "alarmSourceName", width: "7%" },
  { title: "告警类别", dataIndex: "alarmSourceType", key: "alarmSourceType", width: "7%" },
  { title: "当前状态", dataIndex: "currentState", key: "currentState", width: "6%" },
  {
    title: "产生时间", dataIndex: "happenDate", key: "happenDate", width: "7%",
    render: (text, record) => {
      if (text) {
        let tempArry = text.split(' ');
        if (tempArry.length === 3) {
          tempArry = text.split('  ');
        }
        return <span>{tempArry[0]}<br />{tempArry[1]}</span>
      } else { return <span>{text}</span> }
    }
  },
  {
    title: "更新时间", dataIndex: "updateDate", key: "updateDate", width: "7%",
    render: (text, record) => {
      if (text) {
        let tempArry = text.split(' ');
        if (tempArry.length === 3) {
          tempArry = text.split('  ');
        }
        return <span>{tempArry[0]}<br />{tempArry[1]}</span>
      } else { return <span>{text}</span> }
    }
  },
  {
    title: "持续时间", dataIndex: "continueDate", key: "continueDate", width: "5%",
    render: (text, record) => {
      if (text) {
        let tempArry = text.split(' ');
        if (tempArry.length === 3) {
          tempArry = text.split('  ');
        }
        return <span>{tempArry[0]}<br />{tempArry[1]}</span>
      } else { return <span>{text}</span> }
    }
  },
  {
    title: "确认时间", dataIndex: "ensureDate", key: "ensureDate", width: "7%",
    render: (text, record) => {
      if (text) {
        let tempArry = text.split(' ');
        if (tempArry.length === 3) {
          tempArry = text.split('  ');
        }
        return <span>{tempArry[0]}<br />{tempArry[1]}</span>
      } else { return <span>{text}</span> }
    }
  },
  { title: "确认人", dataIndex: "ensurePerson", key: "ensurePerson", width: "4%" },
  {
    title: "清除时间", dataIndex: "clearDate", key: "clearDate", width: "7%",
    render: (text, record) => {
      if (text) {
        let tempArry = text.split(' ');
        if (tempArry.length === 3) {
          tempArry = text.split('  ');
        }
        return <span>{tempArry[0]}<br />{tempArry[1]}</span>
      } else { return <span>{text}</span> }
    }
  },
  { title: "清除人", dataIndex: "clearPerson", key: "clearPerson", width: "4%" },
];

/**
 * @class Warn
 * @extends {Component}
 * @description 告警信息业务屏
 */
class Warnings extends Component {

  constructor() {
    super();
    this.state = {
      selectedRowKeys: [],
      //分页参数
      pageItem: {
        current: 0,
        pageSize: 10,
        total: 1
      },
      pageItem1: [
        {
          // name: 'alarmLevel',
          name: 'sourceId',
          type: 'LIKE',
          value: ''
        }
      ],
      //搜索框查询参数
      queryParams: {
        searchValue: ''
      },
      //告警信息集合
      warnings: []
    };
  }

  componentDidMount() {
    this.initData();
  }

  initData = () =>{
    if (this.props.location.state) {
      let sourceId = this.props.location.state.sourceId;
      this.onIconClick(null, sourceId.toString());
    } else {
      this.getWarningsByPage();
    }
  }

  getWarningsByPage = (arr) => {
    let { pageItem1, pageItem } = this.state;
    let current = pageItem.current;

    if (arr) {
      current = arr - 1;
    }

    getWarningsByPageData(pageItem1, current, pageItem.pageSize).then((data) => {
      if (data.content.length > 0) {
        this.setState({
          warnings: data.content,
          pageItem: {
            current: data.number,
            pageSize: data.size,
            total: data.totalElements
          }
        });
      }
    });
  }

  onSelectChange = (selectedRowKeys, selectionRows) => {
    console.log('selectedRowKeys changed: ', selectedRowKeys, selectionRows);
    let temp = [];
    selectionRows.map(item => {
      temp.push(item.id);
    });
    this.setState({
      selectedRowKeys,
      selectedIds: temp
    });
  }

  onChange = (pageNumber) => {
    this.getWarningsByPage(pageNumber);
  }

  /**
   * 搜索
   */
  onIconClick = (e, value) => {
    if (value === undefined){ value = ''; }
    let { pageItem1 } = this.state;
    pageItem1[0].value = value;
    this.setState({
      pageItem1
    }, () => {
      this.getWarningsByPage(1);
    });
  }

  /**
   * 导出数据列表
   */
  onClickExport = (data) => {
    let url = getWarningsExcelData();
    window.open(url);
  }

    /**
   * webSocket接收数据
   */
  handleData = data => {
    if (data){
      console.log('alarmMarqueeWS');
      this.initData();
    }
  };

  render() {
    let columns = columnss();
    let { selectedRowKeys, warnings, pageItem } = this.state;
    const rowSelection = {
      selectedRowKeys,
      onChange: this.onSelectChange
    };
    const wsURL = completeToken(SysWsURL.view3dws);
    return (
      <div className="amos-warn" style={{ overflow: 'auto', height: '100%' }}>
        <AmosWebSocket ref={node => (this.aws = node)} url={wsURL} onMessage={this.handleData} reconnect debug />
        <div className="amos-warn-up">
          <Row >
            <Col span={24} className="amos-warn-top">
              <Col span={17}></Col>
              <Col span={5}>
                <Search icon="search" style={{ color: '#345FA6' }} placeholder="请输入设备编号" onIconClick={this.onIconClick} />
              </Col>
              <Col span={1}>
                <div className="amos-warn-top-btn"  title="导出" >
                  <Icon icon="download" style={{ color: '#345FA6' }} onClick={() => { this.onClickExport() }} />
                </div>
              </Col>
            </Col>
            <Col span={24} className="amos-warn-table">
              <Table
                size="small"
                columns={columns}
                dataSource={warnings}
                pagination={false}
              />
            </Col>
          </Row>
        </div>
        <div className="data-list-pagination">
          <Pagination
            showQuickJumper
            total={pageItem.total}
            onChange={this.onChange}
            showTotal={(e) => { return "共 " + e + " 条" }}
          />
        </div>
      </div>
    );
  }
}

export default Warnings;
