import React, { Component } from 'react';
import classnames from 'classnames';
import { message } from 'amos-framework';
import dt2react from 'dt2react';
import AmosWebSocket from 'amos-websocket';
import TopologyComponent from './TopologyComponent';
import TreeComponent from './TreeComponent';
import SysWsURL from './../../../consts/wsUrlConsts';


import { getTypeBySystem } from './../financialCityLan/conf';
import { getTopoTreeByTypeAction, getNodesByTypeAndTreeIdAction, saveNodesByTypeUrlAction } from './../../../services/monitorService';

const type = getTypeBySystem('CloudPlatform');

//偏移
const offsetHeight = 110;
const defaultHeight = 450;

class VirtualCloudPlatform extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10,
      pageNumber: 1
    };
    this.state = {
      treeData: [
        {
          name: '',
          id: '1',
          children: []
        }
      ], //树数据

      autoExpandParent: true,
      selectedKeys: [],
      expandedKeys: [],
      topologyData: {}, //拓扑图数据
      tableData: [],
      isTreeDisplay: true,
      isTableDisplay: true,
      activeView: 'left',
      pHeight: 0,
      cityLine: '',
      totalCount: 0,
      searchParam: [],
      selectedRows: [],
      selectedRowKeys: [],
      pagination: true,
      isChecked: false
    };
    this.updateTopologyData = {};
    this.mapView = true;
  }
  componentWillMount() {}

  componentDidMount() {
    this.initData();
  }

  getPanelHeight = () => {
    let tableNode = this.tableNode;
    let tableLocation = dt2react.getOffset(tableNode) || {};
    return (tableLocation !== undefined ? tableLocation.height - offsetHeight : defaultHeight) - 30;
  };

  // 数据初始化
  initData = () => {
    let expandedKeysData = [];
    getTopoTreeByTypeAction(type).then(data => {
      if(data.length >0){
        data.map(item => {
          expandedKeysData.push(item.id);
        });
        this.initTopologyData(data[0].id);
        //this.initTopologyEventData();
        this.setState(
          {
            treeData: data,
            selectedKeys: [data[0].id],
            expandedKeys: expandedKeysData,
            pHeight: this.getPanelHeight()
          }
        );
      }else {
        this.setState(
          {
            treeData: [],
            selectedKeys: [''],
            expandedKeys: expandedKeysData,
            pHeight: this.getPanelHeight()
          }
        );
      }


    });
  };

  // 拓扑图数据初始化
  initTopologyData = (id, value = '') => {
    getNodesByTypeAndTreeIdAction(type, id).then(data => {
      if (value === 'refresh') {
        message.success('拓扑图刷新成功!');
      }

      //console.log('视图刷新成功!');
      this.setState({
        topologyData: data
      });
    });
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  // 树选择
  onSelect = (selectedKeys, e) => {
    if (selectedKeys.length && !e.node.props.parent) {
      window.localStorage.removeItem('cityLine');
      this.initTopologyData(selectedKeys[0]);
      this.setState({
        selectedKeys
      });
    }
  };


  // 树展开
  onExpand = expandedKeys => {
    this.setState({
      expandedKeys,
      autoExpandParent: false
    });
  };

  // 选择节点
  nodeSelectionChanged = e => {
    // console.log('e',e);
    if (e.isSelected) {
    }
  };

  // 节点数据改变
  nodeChange = e => {
    // console.log(e.model.toJson());
    this.updateTopologyData = JSON.parse(e.model.toJson());
  };

  // 保存节点数据
  saveTopologyData = () => {
    const { selectedKeys } = this.state;
    const { nodeDataArray, linkDataArray } = this.updateTopologyData;
    const params = {
      treeid: selectedKeys[0],
      nodeData: nodeDataArray,
      linkData: linkDataArray
    };
    saveNodesByTypeUrlAction(type, params).then(data => {
      message.success('拓扑图保存成功!');
    });
  };

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }

    this.pageConfig.pageNumber = current;
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  // 刷新节点
  refreshTopologyData = () => {
    const { selectedKeys } = this.state;
    this.initTopologyData(selectedKeys[0], 'refresh');
  };

  // 视图切换
  toggleView = value => {
    if (value === 'left') {
      this.setState({
        isTreeDisplay: true,
        isTableDisplay: true,
        activeView: 'left'
      });
    } else {
      this.setState({
        isTreeDisplay: false,
        isTableDisplay: false,
        activeView: 'detail'
      });
    }

    //拓扑图刷新
    const { selectedKeys } = this.state;
    this.initTopologyData(selectedKeys[0], '');
  };

  //webSocket 接收消息
  handleData = data => {
    const { selectedKeys } = this.state;
    this.initTopologyData(selectedKeys[0], '');
  };

  handetopologyData = topologyData => {
    let pointdatas = topologyData.nodeData || [];
    let newNodeData = [];
    console.log(pointdatas);
    pointdatas.map(e => {
      if (e && e.ports && null !== e.ports) {
        var jsonObj = JSON.parse(e.ports);
        let item = { ...e, ...jsonObj };
        newNodeData.push(item);
      } else if (e) {
        let item = e;
        newNodeData.push(item);
      }
    });

    topologyData.nodeData = newNodeData;

    return topologyData;
  };

  render() {
    const { treeData, selectedKeys, expandedKeys, isTreeDisplay } = this.state;

    if (treeData[0] && treeData[0].children.length < 1) {
      return null;
    }
    if (treeData && treeData.length > 0 && selectedKeys && selectedKeys.length > 0) {
      if (treeData[0].id !== selectedKeys[0]) {
        this.mapView = false;
      } else {
        this.mapView = true;
      }
    }

    let { topologyData } = this.state;
    let newtopologyData = this.handetopologyData(topologyData);
    const { isTableDisplay, activeView } = this.state;
    console.log(topologyData);
    return (
      <div className="virtualCloudPlatform-wrapper">
        <AmosWebSocket ref={node => (this.aws = node)} url={SysWsURL.technologyIpURI} onMessage={this.handleData} reconnect debug />
        <div className="virtualCloudPlatform-header">
          <div className="virtualCloudPlatform-view">
            <div className={classnames('left-view', { 'left-active-view': activeView === 'left' })}>
              <img src="/src/assets/bizView/netTopology/left-view.png" alt="左视图" onClick={() => this.toggleView('left')} />
            </div>
            <div className={classnames('detail-view', { 'detail-active-view': activeView === 'detail' })}>
              <img src="/src/assets/bizView/netTopology/detail-view.png" alt="详细视图" onClick={() => this.toggleView('detail')} />
            </div>
          </div>
          <div className="virtualCloudPlatform-data">
            <div className="virtualCloudPlatform-topo-save">
              <img src="/src/assets/bizView/netTopology/save.png" alt="保存" onClick={this.saveTopologyData} />
            </div>
            <div className="virtualCloudPlatform-topo-refresh">
              <img src="/src/assets/bizView/netTopology/refresh.png" alt="刷新" onClick={this.refreshTopologyData} />
            </div>
          </div>
        </div>
        <div className="virtualCloudPlatform-content">
          {
            <div className={classnames({ 'left-content': isTreeDisplay, 'left-content-close': !isTreeDisplay })}>
              <TreeComponent
                treeData={treeData}
                //treeData={moniTreeData}
                selectedKeys={selectedKeys}
                expandedKeys={expandedKeys}
                // onSelect={this.onSelect}
                onExpand={this.onExpand}
              />
            </div>
          }
          <div className={`middle-content ${isTreeDisplay && isTableDisplay ? '' : 'only-middle'}`}>
            <div className="paslogy-content">
              <div className="middle-content-div"></div>
              <div className="net-topo-content">
                <TopologyComponent
                  topologyData={newtopologyData}
                  //nodeSelectionLinkChanged={this.nodeSelectionLinkChanged}
                  nodeSelectionChanged={this.nodeSelectionChanged}
                  nodeChange={this.nodeChange}
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

VirtualCloudPlatform.propTypes = {};

export default VirtualCloudPlatform;
