import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker, TreeSelect } from 'amos-antd';
import moment from 'moment';
import { Form, Input, Button, Select } from 'amos-framework';
import { queryPlanByOrgNoPageAction, queryAllRouteAction, queryCatalogTreeAction } from '../../../services/patrolService';
import momentDateUtil from '../../../utils/momentDateUtil';

const FormItem = Form.Item;
const Option = Select.Option;
const okStatusEnum = [{ id: '1', name: '合格' }, { id: '2', name: '不合格' }, { id: '3', name: '漏检' }];
const fixedDataEnum = [{ id: '0', name: '移动' }, { id: '1', name: '固定' }];
const statusDataEnum = [{ id: '0', name: '计划外完成' }, { id: '1', name: '按时完成' }, { id: '2', name: '未执行'}];
const dateRangeData = [
  { id: '1', name: '今天' },
  { id: '2', name: '昨天' },
  { id: '3', name: '本月' },
  { id: '4', name: '上月' },
  { id: '5', name: '本周' },
  { id: '6', name: '上周' },
  { id: '7', name: '最近7天' },
  { id: '8', name: '最近30天' },
  { id: '9', name: '最近12月' },
  { id: '10', name: '今年' },
  { id: '11', name: '去年' },
  { id: '12', name: '全部' }
];

/**
 * 巡检计划执行查询
 *
 * @class CheckSearch
 * @extends {Component}
 */
class CheckSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        beginDate: {
          name: 'beginDate',
          value: moment()
            .startOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        endDate: {
          name: 'endDate',
          value: moment()
            .endOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        userName: {
          name: 'userName',
          value: ''
        },
        pointNo: {
          name: 'pointNo',
          value: ''
        },
        pointName: {
          name: 'pointName',
          value: ''
        },
        isFixed: {
          name: 'isFixed',
          value: ''
        },
        catalogId: {
          name: 'catalogId',
          value: ''
        },
        finishStatus: {
          name: 'finishStatus',
          value: ''
        },
        isOK: {
          name: 'isOK',
          value: ''
        },
        planId: {
          name: 'planId',
          value: ''
        },
        routeId: {
          name: 'routeId',
          value: ''
        }
      },
      dateRange: '1',
      routeData: [],
      planData: [],
      searchParam: [],
      treeData: []
    };
  }

  componentWillMount = () => {
    this.queryRouteByOrgCode();
    this.queryCatalogTree();
    let { searchParam, form } = this.state;
    let { planId, pointNo } = this.props;
    form.planId.value = planId;
    form.pointNo.value = pointNo;
    this.queryPlanByOrgNoPage(searchParam);
    this.setState({ form: form });
  };

  queryPlanByOrgNoPage = searchParam => {
    queryPlanByOrgNoPageAction(searchParam).then(data => {
      let planData = data;
      this.setState({ planData: planData });
    });
  };

  queryRouteByOrgCode = () => {
    queryAllRouteAction().then(data => {
      let routeData = data;
      this.setState({ routeData: routeData });
    });
  };

  queryCatalogTree = () => {
    queryCatalogTreeAction().then(data => {
      let treeData = data;
      this.setState({ treeData: treeData });
    });
  };

  handleSubmit = () => {
    let { form } = this.state;
    const param = { pageNumber: 0, pageSize: 10 };
    this.props.search(form, param);
  };

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  };

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format('YYYY-MM-DD HH:mm:ss');
    this.setState({ form });
  };

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  };

  onDateRangeChange = (key, value) => {
    let date = {};
    if (value === '1') {
      date = momentDateUtil.getToday();
    } else if (value === '2') {
      date = momentDateUtil.getYesterday();
    } else if (value === '3') {
      date = momentDateUtil.gettCurrMonthDays();
    } else if (value === '4') {
      date = momentDateUtil.getLastMonthDays();
    } else if (value === '5') {
      date = momentDateUtil.getCurrWeekDays();
    } else if (value === '6') {
      date = momentDateUtil.getLastWeekDays();
    } else if (value === '7') {
      date = momentDateUtil.getLast7Days();
    } else if (value === '8') {
      date = momentDateUtil.getLast30Days();
    } else if (value === '9') {
      date = momentDateUtil.getLast12MonthDays();
    } else if (value === '10') {
      date = momentDateUtil.getThisYearDays();
    } else if (value === '11') {
      date = momentDateUtil.getLastYearDays();
    } else {
      date.beginDate = moment()
        .year(moment().year() - 3)
        .startOf('year')
        .format('YYYY-MM-DD HH:mm:ss');
      date.endDate = moment()
        .endOf('day')
        .format('YYYY-MM-DD HH:mm:ss');
    }
    let { beginDate, endDate } = date;
    let { form } = this.state;
    form.beginDate.value = beginDate;
    form.endDate.value = endDate;
    this.setState(form);
  };

  render() {
    const { form, routeData, planData, dateRange } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>时间范围</span>} field="dateRange" {...formItemLayout}>
          <Select
            data={dateRangeData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultValue={dateRange}
            className="search_Input"
            onChange={e => this.onDateRangeChange('dateRange', e)}
          />
        </FormItem>
        <FormItem label={<span>检查开始时间</span>} field="beginDate" {...formItemLayout}>
          <DatePicker
            style={{ width: 147.4 }}
            className="search_Input"
            value={moment(form.beginDate.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('beginDate', e)}
            //允许选择时间
            showTime={{ defaultValue: moment('00:00:00', 'HH:mm:ss') }}
          />
        </FormItem>
        <FormItem label={<span>检查结束时间</span>} field="endDate" {...formItemLayout}>
          <DatePicker
            style={{ width: 147.4 }}
            className="search_Input"
            value={moment(form.endDate.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('endDate', e)}
              //允许选择时间
            showTime={{ defaultValue: moment('00:00:00', 'HH:mm:ss') }}
          />
        </FormItem>
        <FormItem label={<span>检查人员</span>} field="userName" {...formItemLayout}>
          <Input  value={form.userName.value} className="risk-list-input" onChange={e => this.onChange('userName', e)} />
        </FormItem>
        <FormItem label={<span>点编号</span>} field="pointNo" {...formItemLayout}>
          <Input  value={form.pointNo.value} className="risk-list-input" onChange={e => this.onChange('pointNo', e)} />
        </FormItem>
        <FormItem label={<span>点名称</span>} field="pointName" {...formItemLayout}>
          <Input  value={form.pointName.value} className="risk-list-input" onChange={e => this.onChange('pointName', e)} />
        </FormItem>
        <FormItem label={<span>执行情况</span>} field="finishStatus" {...formItemLayout}>
          <Select
            data={statusDataEnum}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.finishStatus.value}
            className="risk-list-input"
            onChange={e => this.onSelectChange('finishStatus', e)}
          />
        </FormItem>
        <FormItem label={<span>状态</span>} field="isOK" {...formItemLayout}>
          <Select
            data={okStatusEnum}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.isOK.value}
            className="risk-list-input"
            onChange={e => this.onSelectChange('isOK', e)}
          />
        </FormItem>
        <FormItem label={<span>安全检查计划</span>} field="planId" {...formItemLayout}>
          <Select
            searchable
            className="risk-list-input"
            data={planData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.planId.value}
            onChange={e => this.onSelectChange('planId', e)}
          />
        </FormItem>
        <FormItem label={<span>安全检查表</span>} field="routeId" {...formItemLayout}>
          <Select
            searchable
            data={routeData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.routeId.value}
            className="risk-list-input"
            onChange={e => this.onSelectChange('routeId', e)}
          />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

CheckSearch.propTypes = {

};

export default CheckSearch;
