import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Table } from 'amos-antd';

/**
 * 巡检记录详情
 */
class CheckInputTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: props.outterPageConfig ? props.outterPageConfig.current : 1,
      pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 10
    };
    this.state = {
      loading: false,//页面是否加载中,默认false
      dataList: [],//表格数据集合
      size: 'middle',//表格大小
      current: props.defaultPageConfig ? props.defaultPageConfig.current : 1,//当前页初始索引0
      pageSize: props.defaultPageConfig ? props.defaultPageConfig.pageSize : 10,//当前页数据量
      totals: 1,//所有数据总和
      maxHeight: 250
    };
  }

  /**
   * 初始获取表格数据
   */
  componentDidMount() {
    this.props.callBack(this.reload);
    this.getHeightOffset();
    window.addEventListener('resize', this.onWindowResize);
  }

  componentWillUnmount() {
    window.removeEventListener('resize', this.onWindowResize);
  }

  onWindowResize = (e) => {
    this.getHeightOffset();
  }

  /**
   * 设置页面数据大小事件
   */
  onSizeChange = (current, pageSize) => {
    let { setPageConfig } = this.props;
    setPageConfig && setPageConfig({ current, pageSize });
    this.setState({ current, pageSize },this.reload);
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    let { setPageConfig } = this.props;
    setPageConfig && setPageConfig({ current });
    this.setState({ current },this.reload);
  }

  setPageConfig = ({ pageSize,current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  }

  /**
   * 获取表格数据（刷新）
   */
  reload = () => {
    let { current,pageSize } = this.state;
    // this.props.getTableDataAction({ current: current - 1, pageSize });
    // this.getHeightOffset();
  }

  showTotal = (total) => {
    return `共 ${total} 条`;
  }

  generateRowkey = (record, index) => {
    return record.id ? record.id : index + (this.state.current - 1) * this.state.pageSize;
  }

  getHeightOffset = () => {
    let { getPanelHeight } = this.props;
    let height = getPanelHeight === undefined ? '850' : getPanelHeight();
    height && this.setState({ maxHeight: height });
  }

  render() {
    let { size, loading, maxHeight } = this.state;
    let { columns, dataSource, totals, pagination } = this.props;
    let defaultPageConfig = this.pageConfig;
    let rowKey = this.generateRowkey;
    let _tempPagination = pagination === false ? false : pagination || {
      size: 'small',
      total: totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: true,
      showTotal: this.showTotal
    };
    let bordered = true;
    // 当为true 或 undefined时则分页
    let _pagination = _tempPagination;

    return (
      <Table
        setPageConfig={this.setPageConfig}
        loading={loading}
        rowKey={rowKey}
        columns={columns}
        dataSource={dataSource}
        bordered={bordered}
        pagination={_pagination}
        scroll={{ y: maxHeight }}
        size={size}
        defaultPageConfig={defaultPageConfig}
      />
    );
  }
}

CheckInputTable.propTypes = {
  columns: PropTypes.array,
  dataSource: PropTypes.array,
  bordered: PropTypes.bool,
  pagination: PropTypes.bool,
  rowKey: PropTypes.number,
  totals: PropTypes.number,
  setPageConfig: PropTypes.func, //把分页参数给父类
  getTableDataAction: PropTypes.func,
  getPanelHeight: PropTypes.func,
  callBack: PropTypes.fuc
};

export default CheckInputTable;
