import React, { Component } from 'react';
import { IFrame } from 'amos-framework';
import { Store } from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { getOutterURL } from '../../../consts/urlConsts';
import { activitiMapping } from '../../../routes/customRoutes';

const lsTool = Store.lsTool;
/**
 * 检查标准
 *
 * @class CheckStandard
 * @extends {Component}
 */

class CheckStandard extends Component {
  render() {
    let url = getOutterURL('activitiURI');
    url = `${url}/${activitiMapping.checkStandard}?token={token}`;
    let token = lsTool.read(SysConsts.token);
    url = formatUrl(url, { token });
    return (
      <div className="rule-model">
        <IFrame
          url={url}
          width="100%"
          height="100%"
          display="initial"
          position="relative"
          allowFullScreen
          scrolling="auto"
        />
      </div>
    );
  }
}
CheckStandard.propTypes = {

};

export default CheckStandard;
