import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Button, Select } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;

class MonitorPointModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        code: '',
        name: '',
        type: '',
        value: ''
      },
      rules: {
        code: [
          { required: true, message: '请输入点位编号' },
          { pattern: new RegExp(/[^\u4e00-\u9fa5]+$/), message: '编号不能包含中文' },
          { pattern: new RegExp(/^[^ ]+$/), message: '编号不能为空或含有空格' },
          {
            // validator: (rule, value, callback) => {

            //   const { pointId } = this.props;
            //   this.queryAllPointNo(pointId);
            //   const { pointNoData } = this.state;
            //   if (!pointNoData.includes(value)) {
            //     callback();
            //   } else {
            //     callback(new Error('该编号已存在！'));
            //   }
            // }
          }
        ],
        name: [
          { required: true, message: '请输入名称' }
        ],
        type: [
          { required: true, message: '请选择类型' }
        ],
        value: [
          { required: true, message: '请输入参数' },
          { pattern: new RegExp(/^(-?\d+)(\.\d+)?$/), message: '请输入正确参数' }
        ]
      }
    };
  }

  componentWillReceiveProps() {
    let { form } = this.props;
    if (form !== undefined) {
      this.setState({
        form
      });
    } else {
      this.setState({
        form: {
          code: '',
          name: '',
          type: '',
          value: ''
        }
      });
    }
  }

  renderParamValueView(formItemLayout) {
    let { form } = this.state;
    let type = form.type;
    // if (type === 'SWITCH') {
    //   return (
    //     <FormItem label={<span>参数</span>} field="value" {...formItemLayout}>
    //       <Select prefixCls="" className="monitor-point-config-form-select" value={form.value.toString()} onChange={e => this.onSelectChange('value', e)}>
    //         <Option value="1">开</Option>
    //         <Option value="0">合</Option>
    //       </Select>
    //     </FormItem>);
    // } else {
    //   return (
    //     <FormItem label={<span>单位</span>} field="value" {...formItemLayout}>
    //       <Input className="monitor-point-config-form-input" value={form.value} placeholder="" onChange={e => this.onChange('value', e)} />
    //     </FormItem>);
    // }
    if (type === 'ANALOGUE') {
      return (
        <FormItem label={<span>单位</span>} field="value" {...formItemLayout}>
          <Input className="monitor-point-config-form-input" value={form.value} placeholder="" onChange={e => this.onChange('value', e)} />
        </FormItem>);
    }
  }

  render() {
    let { form, rules } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 26 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 26 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <div>
        <Form model={form} rules={rules}>
          <FormItem label={<span>点位编号</span>} field="code" {...formItemLayout}>
            <Input className="monitor-point-config-form-input" value={form.code} placeholder="点位编号唯一" onChange={e => this.onChange('code', e)} />
          </FormItem>
          <FormItem label={<span>名称</span>} field="name" {...formItemLayout}>
            <Input className="monitor-point-config-form-input" value={form.name} placeholder="" onChange={e => this.onChange('name', e)} />
          </FormItem>
          <FormItem label={<span>类型</span>} field="type" {...formItemLayout}>
            <Select prefixCls="" className="monitor-point-config-form-select" value={form.type} onChange={e => this.onSelectChange('type', e)}>
              <Option value="ANALOGUE">模拟量</Option>
              <Option value="SWITCH">开关量</Option>
            </Select>
          </FormItem>
          <div>{this.renderParamValueView(formItemLayout)}</div>
          <FormItem>
            <div className="operation-button">
              <Button onClick={this.handleSubmit}>确定</Button>
              <Button onClick={e => this.handleCancel(e, this)}>取消</Button>
            </div>
          </FormItem>
        </Form>
      </div>
    );
  }
}

MonitorPointModel.propTypes = {
  form: PropTypes.object
};

export default MonitorPointModel;
