import React, { Component } from 'react';
import { Tabs } from 'amos-antd';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import FireStationTable from './FireStrength';
import BizIcon from './../../../../common/icon/BizIcon';

const TabPane = Tabs.TabPane;

class FireStrengthView extends Component {
  constructor(props) {
    super(props);

    this.state = {
      oparate: 0
    };
  }
  componentWillReceiveProps = (nextProps) => {
    this.setState({ oparate: 0 });
  }
  onTabClick = key => {
    let searchParam = {};
    searchParam.pageNumber = 0;
    searchParam.pageSize = 10;
    if (key === '1') {
      this.getFireWaterData(searchParam);
    }
    this.setState({ activeKey: key });
  };


  addWaterResource = () => {
    this.setState({ oparate: 1 });
  }

  editWaterResource = () => {
    this.setState({ oparate: 2 });
  }

  deleteWaterResource = () => {
    this.setState({ oparate: 3 });
  }

  render() {
    let { oparate } = this.state;
    const extra = [
      <Button icon={<BizIcon icon="tianjia" />} transparent onClick={this.addWaterResource} />,
      <Button icon={<BizIcon icon="xiugai" />} transparent onClick={this.editWaterResource} />,
      <Button icon={<BizIcon icon="shanchu" />} transparent onClick={this.deleteWaterResource} />
    ];
    return (
      <div className="monitor-video" style={{ background: '#33333', height: '100%' }}>
        <div className="important-equipment-toolbar">
          <div className='important-equipment-title'>
            <span>消防力量</span>
          </div>
          <div className='important-equipment-tools'>
            <Button icon={<BizIcon icon="tianjia" />} transparent onClick={() => this.addWaterResource()} />
            <Button icon={<BizIcon icon="xiugai" />} transparent onClick={() => this.editWaterResource()} />
            <Button icon={<BizIcon icon="shanchu" />} transparent onClick={() => this.deleteWaterResource()} />
          </div>
        </div>
        <FireStationTable oprType={oparate} />
        {/*
        <Tabs defaultActiveKey="1" onTabClick={this.onTabClick} type="card" tabBarExtraContent={extra} >
          <TabPane tab='消防力量' key='1'>
            <FireStationTable oprType={oparate} />
          </TabPane>
        </Tabs>
        */}
      </div>
    );
  }
}

FireStrengthView.propTypes = {

};
export default FireStrengthView;
