import React, { Component } from 'react';
import { Tabs } from 'amos-framework';
import FireTruck from './FireTruck';
import FireEquipment from './FireEquipment';
import FireFoamable from './fireFoam/fireFoam';
import FireStation from './FireStation/fireStation';
import FireWater from './water/water';
import { getFireEquipmentListAction, getFireTruckListAction } from './../../../../services/ledgerService';

const { TabList, Tab, TabPanel } = Tabs;
const tabs = [
  { id: '1', closable: false, title: '消防车' },
  { id: '2', closable: false, title: '消防装备' },
  { id: '3', closable: false, title: '消防泡沫间' },
  { id: '4', closable: false, title: '消防小室' },
  { id: '5', closable: false, title: '灭火栓' },
  { id: '6', closable: false, title: '消防水池' }
];

class FireResourceView extends Component {
  constructor(props) {
    super(props);

    this.state = {
      activeKey: '1',
      fireTruckDataList: [], //表格数据集合
      fireTruckSearchParam: [],
      fireTruckTotals: 0, //所有数据总和
      fireEquipmentDataList: [], //表格数据集合
      fireEquipmentSearchParam: { equipClassify: '0,1,3' },
      fireEquipmentTotals: 0, //所有数据总和
      fireFoamSearchParam: [{
        name: 'type',
        value: 2
      }],//消防泡沫间查询参数
      fireStationSearchParam: [{
        name: 'type',
        value: 1
      }],//消防小室查询参数
      fireStationDataList: [],
      fireStationTotals: 0,  //消防小室总数
      fireFoamDataList: [],
      fireFoamTotals: 0,  //消防泡沫间总数
      fireWaterDataList: [],
      fireWaterTotals: 0  //消防水资源总数
    };
  }

  componentWillMount() {
    const { activeKey } =  this.props.location.state || {};
    this.setState({ activeKey: activeKey === undefined ? '1' : activeKey });
  }

  onTabClick = key => {
    this.setState({ activeKey: key });
  };

  getFireTruckListData = (param, _table) => {
    _table && (_table.state.selectedRowKeys = []);
    let { fireTruckSearchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    Object.assign(fireTruckSearchParam, { ...param });
    getFireTruckListAction(fireTruckSearchParam, param.pageNumber, param.pageSize).then(data => {
      this.setState({
        fireTruckDataList: data.content,
        fireTruckTotals: data.totalElements
      });
    });
  };

  getFireEquipmentListData = (param, _table) => {
    _table && (_table.state.selectedRowKeys = []);
    let { fireEquipmentSearchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }

    Object.assign(fireEquipmentSearchParam, { ...param });
    getFireEquipmentListAction(fireEquipmentSearchParam, param.pageNumber, param.pageSize).then(data => {
      let monitorData = data.content.filter(item => item.equipClassify === 2);
      let filterData = data.content.filter(item => !new Set(monitorData).has(item));
      let totalElements = data.totalElements - monitorData.length;
      this.setState({
        fireEquipmentDataList: filterData,
        fireEquipmentTotals: totalElements
      });
    });
  };


  render() {
    let { fireTruckDataList, fireTruckTotals, fireEquipmentDataList, fireEquipmentTotals, activeKey } = this.state;
    return (
      <div className="convertor-fire-resource" style={{ background: '#33333', height: '100%' }}>
        <Tabs
          activeKey={activeKey}
          onChange={(index, key) => this.onTabClick(key)}
          destroyContent
          closeAnimate
          cardMode
        >
          <TabList>
            {tabs.map((item, i) => (
              <Tab key={item.id} activeKey={item.id} closable={item.closable}>{item.title}</Tab>)
            )}
          </TabList>
          <TabPanel tab="消防车" activeKey="1">
            <FireTruck dataList={fireTruckDataList} totalCount={fireTruckTotals} getTableListData={this.getFireTruckListData} />
          </TabPanel>
          <TabPanel tab="消防装备" activeKey="2">
            <FireEquipment dataList={fireEquipmentDataList} totalCount={fireEquipmentTotals} getTableListData={this.getFireEquipmentListData} />
          </TabPanel>
          <TabPanel tab='消防泡沫间' activeKey='3'>
            <FireFoamable />
          </TabPanel>
          <TabPanel tab='消防小室' activeKey='4'>
            <FireStation />
          </TabPanel>
          <TabPanel tab='灭火栓' activeKey='5'>
            <FireWater type="1" />
          </TabPanel>
          <TabPanel tab='消防水池' activeKey='6'>
            <FireWater type="2" />
          </TabPanel>
        </Tabs>
      </div>
    );
  }
}

FireResourceView.propTypes = {

};
export default FireResourceView;
