import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select, Radio } from 'amos-framework';
import { stringify } from 'amos-tool';

import { getFireWaterDataAction } from '../../../../../services/ledgerService';

const FormItem = Form.Item;
const Option = Select.Option;
const RadioGroup  = Radio.Group;
const floorData = [{id:'1',name:'1层'},{id:'2',name:'2层'},{id:'3',name:'3层'},{id:'4',name:'4层'},{id:'5',name:'5层'}];


class FireWaterDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {
        name:'',
        code:'',
        address:'',
        room:'',
        productionArea:'',
        position3d:'',
        floor3d:'',
        isIndoor: true
      }
    };
  }
  componentWillMount() {
    const { station } = this.state;
    station.type = this.props.type;
    this.setState({ station });
    this.queryFireStationDetail();
  }

  queryFireStationDetail = () => {
    let { stationId } = this.props;
    getFireWaterDataAction( stationId ).then(station => {
      this.setState({ station });
    });
  }

  render() {
    const { station } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    let name = station.type === '1' ? '消防栓' : '消防水池';
    return (
      <Form  className="basic-demo" model={station} >
        <FormItem label={<span>{name}名称</span>} field="name" {...formItemLayout} >
          <Input
            value={station.name}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>{name}编码</span>} field="code" {...formItemLayout} >
          <Input
            value={station.code }
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="地址" field="address" {...formItemLayout} >
          <Input
            value={station.address}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label='房间' field="room" {...formItemLayout} >
          <Input
            value={station.room}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label='区域' field="productionArea" {...formItemLayout} >
          <Input
            value={station.productionArea}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
            <Input className="risk_factor_input"  value={station.position3d}/>
        </FormItem>
        <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
          <Select
              className="fire-equip-select"
              data={floorData}
              value={station.floor3d}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
              onChange={e => this.onInputChange('floor3d', e)}
          />
        </FormItem>
        <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
          <RadioGroup defaultValue={station.isIndoor} value={station.isIndoor} >
            <Radio value= {false}>否</Radio>
            <Radio value= {true}>是</Radio>
          </RadioGroup>
        </FormItem>
      </Form>
    );
  }
}

FireWaterDetail.propTypes = {
  stationId: PropTypes.number,
  type: PropTypes.number
};
export default FireWaterDetail;
