import React, { Component } from 'react';
import { Tabs } from 'amos-antd';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import FireWater from './water';
import BizIcon from './../../../../common/icon/BizIcon';

const TabPane = Tabs.TabPane;

class FireWaterResourceView extends Component {
  constructor(props) {
    super(props);

    this.state = {
      oparate1: 0,
      oparate2: 0,
      activeKey: 1
    };
  }
  componentWillReceiveProps = (nextProps) => {
    this.setState({ oparate1: 0,  oparate2: 0 });
  }
  onTabClick = key => {
    this.setState({ activeKey: key , oparate1: 0,  oparate2: 0 });
  };


  toolbarButtonOnClick = (key) => {
    const { activeKey } = this.state;
    if ( parseInt(activeKey) === 1 ) {
      this.setState({ oparate1: parseInt(key), oparate2: 0 });
    } else {
      this.setState({ oparate2: parseInt(key) , oparate1: 0 });
    }
  }

  render() {
    let { oparate1, oparate2 } = this.state;
    const extra = [
      <Button key="add" transparent icon={<BizIcon icon="tianjia" />} onClick={() => this.toolbarButtonOnClick(1)} />,
      <Button key="edit" transparent icon={<BizIcon icon="xiugai" />} onClick={() => this.toolbarButtonOnClick(2)} />,
      <Button key="del" transparent icon={<BizIcon icon="shanchu" />} onClick={() => this.toolbarButtonOnClick(3)} />
    ];

    return (
      <div className="convertor-fire-resource" style={{ background: '#33333', height: '100%' }}>
        <Tabs defaultActiveKey="1" onTabClick={this.onTabClick} type="card" tabBarExtraContent={extra} >
          <TabPane tab='灭火栓' key='1'>
            <FireWater oprType={oparate1} type="1" />
          </TabPane>
          <TabPane tab='消防水池' key='2'>
            <FireWater oprType={oparate2} type="2"  />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}

FireWaterResourceView.propTypes = {

};
export default FireWaterResourceView;
