import React, { Component } from 'react';
import moment from 'moment';
import PropTypes from 'prop-types';
import { Input, Form, Button, Select } from 'amos-framework';
import { DatePicker } from 'amos-antd';
import { getRegionDepartmentTreeAction, getDepatUserListAction } from '../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;
const { RangePicker } = DatePicker;

class DangerListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        eqCode: '',
        eqName: '',
        dangerName: '',
        dangerPosition: '',
        dangerLevel: '',
        reformType: '',
        beginDeadline: '',
        endDeadline: '',
        dangerState: '',
        overtimeState: '',
        measures: '',
        planType: '',
        planName: '',
        routeName: '',
        dangerType: '',
        beginCheckTime: '',
        endCheckTime: '',
        checkContent: '',
        checkDep: '',
        checkUser: '',
        checkResult: '',
        checkStatus: '',
        dangerId: '',
        governDep: '',
        governUser: '',
        verifyDep: '',
        verifyUser: '',
        verifyResult: ''
      },
      departmentData: [],
      checkUserData: [],
      verifyUserData: [],
      governUserData: []
    };
  }

  componentDidMount() {
    this.getRegionDepartmentTreeData();
  }

  componentWillReceiveProps(nextProps) {

  }

  onClick = () => {
    const { form } = this.state;
    this.props.search(form);
  }

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  onSelectChange = (type, value, obj) => {
    let { form } = this.state;
    if ((type === 'checkTime' || type === 'deadline') && Array.isArray(value)) {
      let startTime;
      let endTime;
      startTime = value[0] ? value[0].format('YYYY-MM-DD HH:mm:ss') : '';
      endTime = value[1] ? value[1].format('YYYY-MM-DD HH:mm:ss') : '';
      if (type === 'checkTime') {
        form['beginCheckTime'] = startTime;
        form['endCheckTime'] = endTime;
      } else if (type === 'deadline') {
        form['beginDeadline'] = startTime;
        form['endDeadline'] = endTime;
      }
    } else if (type === 'checkDep' || type === 'governDep' || type === 'verifyDep') {
      getDepatUserListAction(value).then(data => {
        let { form, checkUserData, verifyUserData, governUserData } = this.state;
        if (type === 'checkDep') {
          checkUserData = [];
          form.checkUser = '';
          data.map(item => {
            let user = {};
            user.name = item.realName;
            user.id = item.userId;
            checkUserData.push(user);
          });
        } else if (type === 'governDep') {
          governUserData = [];
          form.governUser = '';
          data.map(item => {
            let user = {};
            user.name = item.realName;
            user.id = item.userId;
            governUserData.push(user);
          });
        } else {
          verifyUserData = [];
          form.verifyUser = '';
          data.map(item => {
            let user = {};
            user.name = item.realName;
            user.id = item.userId;
            verifyUserData.push(user);
          });
        }
        form[type] = value;
        this.setState({ form, checkUserData, verifyUserData, governUserData });
      });
    } else {
      form[type] = value;
    }
    this.setState({ form });
  };

  getRegionDepartmentTreeData = () => {
    getRegionDepartmentTreeAction().then(data => {
      let { departmentData } = this.state;
      let deptMap = data.secondDepartments;
      let depts = [];
      for (let k in deptMap) {
        depts = [...depts, ...deptMap[k]];
      }
      depts && depts.map(item => {
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        departmentData.push(deptObj);
      });
      this.setState({ departmentData });
    });
  }

  // initFormValues = () => {
  //   const { form } = this.state;
  //   for (let key in form) {
  //     form[key] = '';
  //   }
  //   this.setState({ form });
  // };

  render() {
    let { form, departmentData, checkUserData, verifyUserData, governUserData } = this.state;
    const { searchCommonData } = this.props;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>类型</span>} field="riskLevel" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.type}
            onChange={value => this.onInputChange('type', value)}
          >
            <Option>请选择</Option>
            <Option value="1">设备设施类</Option>
            <Option value="2">非设备设施类</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>设备位号</span>} field="eqCode" {...formItemLayout}>
          <Input value={form.eqCode} className="risk-list-input" onChange={e => this.onInputChange('eqCode', e.target.value)} />
        </FormItem>
        <FormItem label={<span>隐患名称</span>} field="dangerName" {...formItemLayout}>
          <Input value={form.dangerName} className="risk-list-input" onChange={e => this.onInputChange('dangerName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>隐患地点</span>} field="dangerPosition" {...formItemLayout}>
          <Input value={form.dangerPosition} className="risk-list-input" onChange={e => this.onInputChange('dangerPosition', e.target.value)} />
        </FormItem>
        <FormItem label={<span>检查类型</span>} field="planType" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.planType}
            onChange={value => this.onInputChange('planType', value)}
          >
            <Option>请选择</Option>
            <Option value="1">日</Option>
            <Option value="2">周</Option>
            <Option value="3">月</Option>
            <Option value="4">年</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>检查表名称</span>} field="routeName" {...formItemLayout}>
          <Input value={form.routeName} className="risk-list-input" onChange={e => this.onInputChange('routeName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>检查计划名称</span>} field="planName" {...formItemLayout}>
          <Input value={form.planName} className="risk-list-input" onChange={e => this.onInputChange('planName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>检查时间</span>} field="checkTime" {...formItemLayout}>
          <RangePicker
            onChange={e => this.onSelectChange('checkTime', e)}
            value={form.beginCheckTime && form.endCheckTime ? [moment(form.beginCheckTime, 'YYYY-MM-DD HH:mm'), moment(form.endCheckTime, 'YYYY-MM-DD HH:mm')] : null}
            showTime
            format="YYYY-MM-DD HH:mm"
          />
        </FormItem>
        <FormItem label={<span>检查部门</span>} field="checkDep" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={departmentData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.checkDep}
            onChange={e => this.onSelectChange('checkDep', e)}
          />
        </FormItem>
        <FormItem label={<span>检查人员</span>} field="checkUser" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={checkUserData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.checkUser}
            onChange={e => this.onSelectChange('checkUser', e)}
          />
        </FormItem>
        <FormItem label={<span>治理期限</span>} field="deadline" {...formItemLayout}>
          <RangePicker
            onChange={e => this.onSelectChange('deadline', e)}
            value={form.beginDeadline && form.endDeadline ? [moment(form.beginDeadline, 'YYYY-MM-DD HH:mm'), moment(form.endDeadline, 'YYYY-MM-DD HH:mm')] : null}
            showTime
            format="YYYY-MM-DD HH:mm"
          />
        </FormItem>
        <FormItem label={<span>治理部门</span>} field="governDep" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={departmentData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.governDep}
            onChange={e => this.onSelectChange('governDep', e)}
          />
        </FormItem>
        <FormItem label={<span>治理人员</span>} field="governUser" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={governUserData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.governUser}
            onChange={e => this.onSelectChange('governUser', e)}
          />
        </FormItem>
        <FormItem label={<span>隐患级别</span>} field="dangerLevel" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.dangerLevel}
            onChange={value => this.onInputChange('dangerLevel', value)}
          >
            <Option>请选择</Option>
            <Option value="1">一般隐患</Option>
            <Option value="2">重大隐患</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>治理方式</span>} field="reformType" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.reformType}
            onChange={value => this.onInputChange('reformType', value)}
          >
            <Option>请选择</Option>
            <Option value="1">常规整改</Option>
            <Option value="2">安措计划</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>是否逾期</span>} field="overtimeState" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.overtimeState}
            onChange={value => this.onInputChange('overtimeState', value)}
          >
            <Option>请选择</Option>
            <Option value="0">否</Option>
            <Option value="1">是</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>治理进度</span>} field="dangerState" {...formItemLayout}>
          <Select
            className="risk-list-select"
            value={form.dangerState}
            onChange={value => this.onInputChange('dangerState', value)}
          >
            <Option>请选择</Option>
            <Option value="1">待评审</Option>
            <Option value="2">待治理</Option>
            <Option value="3">安措计划中</Option>
            <Option value="4">待验证</Option>
            <Option value="5">治理完毕</Option>
            <Option value="6">已撤销</Option>
          </Select>
        </FormItem>
        <FormItem label={<span>验证部门</span>} field="verifyDep" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={departmentData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.verifyDep}
            onChange={e => this.onSelectChange('verifyDep', e)}
          />
        </FormItem>
        <FormItem label={<span>验证人员</span>} field="verifyUser" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={verifyUserData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.verifyUser}
            onChange={e => this.onSelectChange('verifyUser', e)}
          />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} className="risk-list-search-button">
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

DangerListSearch.propTypes = {
  searchCommonData: PropTypes.object,
  search: PropTypes.func
};

export default DangerListSearch;
