import moment from 'moment';

const typeEnum = { '1': '设备设施类', '2': '非设备设施类' };
const planTypeEnum = { '1': '日', '2': '周', '3': '月', '4': '年' };
const dangerLevelEnum = { '1': '一般隐患', '2': '重大隐患' };
const reformTypeEnum = { '1': '常规整改', '2': '安措计划' };
const overtimeStateEnum = { '0': '否', '1': '是' };
const dangerStateEnum = { '1': '待评审', '2': '待治理', '3': '安措计划中', '4': '待验证', '5': '治理完毕', '6': '已撤销' };
const dangerTypeEnum = { '1': '计划检查', '2': '无计划检查', '3': '无码添加' };

export const DangerListHeader = [
  {
    title: '序号',
    width: '50px',
    render: (text, record, index) => `${index + 1}`
  },
  {
    title: '类型',
    dataIndex: 'type',
    key: 'type',
    width: '100px'
  },
  {
    title: '设备位号',
    dataIndex: 'eqCode',
    key: 'eqCode',
    width: '150px'
  },
  {
    title: '隐患名称',
    dataIndex: 'dangerName',
    key: 'dangerName',
    width: '150px'
  },
  {
    title: '隐患地点',
    dataIndex: 'dangerPosition',
    key: 'dangerPosition',
    width: '150px'
  },
  {
    title: '隐患级别',
    dataIndex: 'dangerLevel',
    key: 'dangerLevel',
    width: '100px'
  },
  {
    title: '治理方式',
    dataIndex: 'reformType',
    key: 'reformType',
    width: '100px'
  },
  {
    title: '治理期限',
    dataIndex: 'deadline',
    key: 'deadline',
    width: '150px'
  },
  {
    title: '治理进度',
    dataIndex: 'dangerState',
    key: 'dangerState',
    width: '100px'
  },
  {
    title: '治理措施',
    dataIndex: 'measures',
    key: 'measures',
    width: '150px'
  },
  {
    title: '治理部门',
    dataIndex: 'governDep',
    key: 'governDep',
    width: '100px'
  },
  {
    title: '治理人员',
    dataIndex: 'governUser',
    key: 'governUser',
    width: '100px'
  },
  {
    title: '治理时间',
    dataIndex: 'governTime',
    key: 'governTime',
    width: '150px'
  },
  {
    title: '是否逾期',
    dataIndex: 'overtimeState',
    key: 'overtimeState',
    width: '100px'
  },
  {
    title: '验收结果',
    dataIndex: 'verifyResult',
    key: 'verifyResult',
    width: '100px'
  },
  {
    title: '验证部门',
    dataIndex: 'verifyDep',
    key: 'verifyDep',
    width: '100px'
  },
  {
    title: '验证人员',
    dataIndex: 'verifyUser',
    key: 'verifyUser',
    width: '100px'
  },
  {
    title: '检查类型',
    dataIndex: 'planType',
    key: 'planType',
    width: '100px'
  },
  {
    title: '检查计划名称',
    dataIndex: 'planName',
    key: 'planName',
    width: '200px'
  },
  {
    title: '检查表名称',
    dataIndex: 'routeName',
    key: 'routeName',
    width: '200px'
  },
  {
    title: '检查方式',
    dataIndex: 'dangerType',
    key: 'dangerType',
    width: '100px'
  },
  {
    title: '检查时间',
    dataIndex: 'checkTime',
    key: 'checkTime',
    width: '150px'
  },
  {
    title: '具体检查内容',
    dataIndex: 'checkContent',
    key: 'checkContent',
    width: '200px'
  },
  {
    title: '检查部门',
    dataIndex: 'checkDep',
    key: 'checkDep',
    width: '100px'
  },
  {
    title: '检查人员',
    dataIndex: 'checkUser',
    key: 'checkUser',
    width: '100px'
  },
  {
    title: '检查结果',
    dataIndex: 'checkResult',
    key: 'checkResult',
    width: '250px'
  }
];
