import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, Input, Button } from 'amos-framework';
import { DatePicker } from 'amos-antd';
import BizIcon from './../../common/icon/BizIcon';

const { RangePicker } = DatePicker;
const Option = Select.Option;
/**
 * 智能判别查询条件
 */

class DifferentiateSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: {},
      areaData: [],
      equipData: []
    };
  }

  componentDidMount() {
    // this.queryAreaPlist();
    this.queryEquipList();
  }

  onSelectChange = (type, value, obj) => {
    let { searchParam } = this.state;
    let param = {};
    if (type === 'time') {
      let startTime;
      let endTime;
      if (value.length !== 0) {
        startTime = value[0].format('YYYY-MM-DD HH:mm:ss');
        endTime = value[1].format('YYYY-MM-DD HH:mm:ss');
      }
      param = { startTime,  endTime };
    } else {
      param[type] = obj.children;
    }
    Object.assign(searchParam, param);
    this.setState({ searchParam });
    this.props.setSearchParam(searchParam);
  };

  onChange = (e, value) => {
    let { searchParam } = this.state;
    Object.assign(searchParam, { [e]: value });
    this.setState(searchParam);
  };

  // queryAreaPlist = () => {
  //   areaPlistNoPageAction().then(data => {
  //     this.setState({ areaData: data });
  //   });
  // };

  queryEquipList = () => {
    // equipNoPageAction().then(data => {
    //   this.setState({ equipData: data });
    // });
  };

  searchData = () => {
    let { searchParam } = this.state;
    this.props.setSearchParam(searchParam);
  };

  render() {
    let { equipData, searchParam } = this.state;
    return (
      <div className="alarm-view-search">
        <div className="alarm-view-select-2">
          <span>判别结果：</span>
          <Select onChange={(e, value) => this.onSelectChange('status', e, value)} defaultValue={-1}>
            <Option value={-1}>全部</Option>
            <Option value={0}>合格</Option>
            <Option value={1}>不合格</Option>
          </Select>
        </div>
        <div className="alarm-view-select-3">
          <span>时间：</span>
          <RangePicker onChange={e => this.onSelectChange('time', e)} showTime format="YYYY-MM-DD HH:mm" />
        </div>
        <div className="alarm-view-input">
          <span>责任人：</span>
          <Input value={searchParam.username} onChange={e => this.onChange('username', e.target.value)} />
        </div>
        <div className="alarm-view-input">
          <span>巡检点：</span>
          <Input value={searchParam.name} onChange={e => this.onChange('name', e.target.value)} />
          <Button icon={<BizIcon icon='sousuo' />} transparent onClick={this.searchData} />
        </div>
      </div>
    );
  }
}

DifferentiateSearch.propTypes = {
  setSearchParam: PropTypes.func
};
export default DifferentiateSearch;
