import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import { fetchMonthCountChkAction } from './../../../services/checkInfoService';
import moment from 'moment';
/**
 * 巡检点统计
 * @class MonthlyInspection
 * @extends {Component}
 */
class MonthlyInspection extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xList: [],
      proData: [],
      actData: [],
      forData: []
    };
  }
  getMonthCountChkData = param => {
    //const countDate ='20181123';
    const countDate = moment().format('YYYYMMDD'); //当前时间查询无记录，测试用固定日期，后期需注释掉上行，放开本行
    fetchMonthCountChkAction(countDate).then(data => {
      let proData = [];
      let actData = [];
      let forData = [];
      let xList = [];
      data &&
        data.map(e => {
          proData.push(e.proNum);
          actData.push(e.actualNum);
          forData.push(e.forNum);
          xList.push(e.checkDate);
        });
      this.setState({
        xList: xList,
        proData: proData,
        actData: actData,
        forData: forData
      });
    });
  };
  componentDidMount() {
    this.getMonthCountChkData();
  }

  getOptions() {
    return {
      tooltip: {
        trigger: 'axis',
        showDelay: 0,
        backgroundColor: 'rgba(34, 34, 34, 1)',
        hideDelay: 50,
        transitionDuration: 0,
        position: function(p) {
          return [p[0] + 10, p[1] - 10];
        },
        textStyle: {
          color: 'white',
          decoration: 'none',
          fontFamily: 'Verdana, sans-serif',
          fontSize: 12,
          fontStyle: 'normal',
          fontWeight: 'normal'
        },
        formatter: function(params, ticket, callback) {
          let res = params[0].name;
          for (let i = 0, l = params.length; i < l; i++) {
            if (params[i].seriesIndex === 0) {
              res += '<br/><span style="color:#41d0f4;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            } else if (params[i].seriesIndex === 1) {
              res += '<br/><span style="color:#66cc00;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            } else if (params[i].seriesIndex === 2) {
              res += '<br/><span style="color:#ffcc00;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            }
          }
          return res;
        },
        axisPointer: {
          type: 'line',
          lineStyle: {
            color: 'rgba(34, 34, 34, 1)',
            width: 2,
            type: 'solid'
          }
        }
      },
      color: ['#41d0f4', '#66cc00', '#ffcc00'],
      legend: {
        show: true,
        y: 'top',
        x: 'right',
        textStyle: {
          color: 'auto'
        },
        data: [
          {
            name: '计划巡检次数',
            icon: 'diamond',
            textStyle: { color: '#41d0f4' }
          },
          {
            name: '实际巡检次数',
            icon: 'diamond',
            textStyle: { color: '#66cc00' }
          },
          {
            name: '漏检次数',
            icon: 'diamond',
            textStyle: { color: '#ffcc00' }
          }
        ]
      },
      grid: {
        x: '10%',
        y: '10%',
        y2: '20%'
      },
      xAxis: [
        {
          type: 'category',
          boundaryGap: false,
          data: this.state.xList,
          //     axisLine:{
          //         show:false,
          //         lineStyle:{
          //             color: '#FFFFFF'
          //          }
          //    },
          axisLabel: {
            show: false,
            textStyle: {
              color: 'black' //'#FFFFFF'
            }
          },
          splitLine: {
            lineStyle: {
              color: ['#FFFFFF']
            }
          }
        }
      ],
      yAxis: [
        {
          type: 'value',
          // axisLine:{
          //     lineStyle:{
          //         color: '#FFFFFF'
          //      }
          // },
          axisLabel: {
            textStyle: {
              color: 'black' //'#FFFFFF'
            }
          },
          splitLine: {
            show: true,
            lineStyle: {
              type: 'dashed',
              width: 2,
              color: '#c9c9c9' //'rgba(34, 34, 34, 1)'
            }
          }
        }
      ],
      series: [
        {
          name: '计划巡检次数',
          type: 'line',
          data: this.state.proData,
          smooth: true,
          symbol: 'none',
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#41d0f4'
              }
            }
          }
        },
        {
          name: '实际巡检次数',
          type: 'line',
          data: this.state.actData,
          symbol: 'none',
          smooth: true,
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#66cc00'
              }
            }
          }
        },
        {
          name: '漏检次数',
          type: 'line',
          data: this.state.forData,
          symbol: 'none',
          smooth: true,
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#ffcc00'
              }
            }
          }
        }
      ]
    };
  }

  render() {
    const option = this.getOptions();
    return (
      <div className="point-month-ins">
        <div className="point-month-ins-title">本月巡检情况统计</div>
        <AmosEcharts option={option} />
      </div>
    );
  }
}

MonthlyInspection.propTypes = {};

MonthlyInspection.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default MonthlyInspection;
