'use strict';

import React, { Component } from 'react';
import { CardPane, Row, Col } from 'amos-framework';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import PointInfoContent from './PointInfoContent';

class PointInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      pointID: null
    };
  }

  componentWillMount(){
    const { pointDetail } = this.props.location.state || {};
    pointDetail && this.setState({ pointID: pointDetail.pointID });
  }

  componentWillReceiveProps(nextProps) {
    const { pointDetail } = nextProps.location.state || {};
    pointDetail && this.setState({ pointID: pointDetail.pointID });
  }

  goBackAction = () => {
    browserHistory.push('/biz/patrolpoint');
  };

  render() {

    const { pointID } = this.state;
    if (!pointID) {
      return null;
    }

    return (
      <PointInfoContent pointID={pointID} goBackAction={this.goBackAction} />
    );
  }
}

export default PointInfo;
