import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../common/tableComponent/table/AmosGridTable';

/**
 *
 * 清单体部分
 * @class CommonBodyTable
 * @extends {Component}
 */
class CommonBodyTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: this.props.isChecked || false,
      selectedRows: [],
      selectedRowKeys: [],
      dataList: [],
      totalCount: 0
    };
  }

  componentWillMount() {
    this.columns = this.props.columns;
  }

  componentDidMount() {

  }

  getRowClassName = (record, index) => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys.findIndex(item => item === record.id) >= 0) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  }

  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  }

  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  }

  render() {
    const { pagination,isChecked, selectedRowKeys } = this.state;
    const defaultPageConfig = this.pageConfig;
    const { fetchData,totalNum,dataList } = this.props;
    return (
      <div className='risk-list-table'>
        <AmosGridTable
          columns={this.columns}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={totalNum}
          getTableDataAction={param => fetchData(param, this)}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowClick={this.onRowClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

CommonBodyTable.propTypes = {
  fetchData: PropTypes.func,
  totalNum: PropTypes.number,
  dataList: PropTypes.array,
  columns: PropTypes.array,
  isChecked: PropTypes.bool
};

export default CommonBodyTable;
