import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';
import QRDetailPopover from './QRDetailPopover';
import { queryRiskLevelEumListAction } from './../../../../../services/bizService';

const getColumns = (self)=> {
  return [
    {
      title: '风险名称',
      dataIndex: 'name',
      key: 'name',
      width: '20%'
    },
    {
      title: '风险编号',
      dataIndex: 'code',
      key: 'code',
      width: '15%'
    },
    {
      title: '辨识人',
      dataIndex: 'username',
      key: 'username',
      width: '10%'
    },
    {
      title: '风险等级',
      dataIndex: 'riskLevel',
      key: 'riskLevel',
      width: '10%',
      render: text => {
        let { riskLevelData } = self.state;
        let risk = riskLevelData && riskLevelData.find(item => item.id === text);
        return risk && risk.level;
      }
    },
    {
      title: '创建者',
      dataIndex: 'createUserName',
      key: 'createUserName',
      width: '10%'
    },
    {
      title: '二维码',
      width: '35%',
      render: record=> {return <QRDetailPopover record={record} />;}
    }
  ];
};

/**
 *
 * 风险区域二维码
 * @class RiskSourceQR
 * @extends {Component}
 */
class RiskSourceQR extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: false,
      selectedRows: [],
      selectedRowKeys: [],
      dataList: [],
      totalCount: 0,
      riskLevelData: []
    };
  }

  componentWillMount() {

  }

  componentDidMount() {
    this.getRiskLevelEumData();
  }

  getRiskLevelEumData = () => {
    queryRiskLevelEumListAction().then(data => {
      this.setState({ riskLevelData: data });
    });
  }

  getRowClassName = (record, index) => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys.findIndex(item => item === record.id) >= 0) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  }

  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  }


  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  }

  operateQR =(record)=>{

  }

  filterData = (dataList) => {
    let list = [];
    list = dataList && dataList.filter(item => item.riskLevel !== '' && item.riskLevel !== null);
    return list;
  }

  render() {
    const { pagination,isChecked, selectedRowKeys } = this.state;
    const defaultPageConfig = this.pageConfig;
    const { fetchData,totalNum,dataList } = this.props;
    let _dataList = this.filterData(dataList);
    return (
      <div className='risk-list-table'>
        <AmosGridTable
          columns={getColumns(this)}
          callBack={this.reload}
          isPageable={pagination}
          dataList={_dataList}
          totals={totalNum}
          getTableDataAction={param => fetchData(param, this)}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowClick={this.onRowClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

RiskSourceQR.propTypes = {
  fetchData: PropTypes.func,
  totalNum: PropTypes.number,
  dataList: PropTypes.array,
  columns: PropTypes.array
};

export default RiskSourceQR;
