import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';
import { getControlMeasAction, getCatalogEumAction } from '../../../../../services/bizService';

const statusEum = { 1: '受控',2: '失控',3: '一般隐患',4: '重大隐患' };
const getColumns = (catalogData) => {
  return [
    {
      title: '控制措施类别',
      dataIndex: 'category',
      key: 'category',
      width: '20%',
      render: text=>(catalogData.find(e=>e.dictDataKey === text) || {}).dictDataValue
    },
    {
      title: '控制措施名称',
      dataIndex: 'name',
      key: 'name',
      width: '20%'
    },
    {
      title: '控制措施详情',
      dataIndex: 'content',
      key: 'content',
      width: '40%'
    },
    {
      title: '受控状态',
      dataIndex: 'status',
      key: 'status',
      width: '20%',
      render: text =>statusEum[text]
    }
  ];
};
/**
 *
 * 管控措施
 * @class ControlMeasures
 * @extends {Component}
 */
class ControlMeasures extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: false,
      isChecked: false,
      selectedRows: [],
      selectedRowKeys: [],
      factorName: '',
      dataList: [],
      totalCount: 0,
      catalogData: []
    };
  }

  componentWillMount() {
    const { factorName,factorId, evaluateId } = this.props;
    factorName && this.setState({ factorName });
    factorId && this.setState({ factorId });
    evaluateId && this.setState({ evaluateId});
    this.getCatalogEumData();
  }

  componentDidMount() {
    const { factorId,evaluateId } = this.state;
    factorId && evaluateId && this.questStatistiscData();
  }

  onRowClick =()=>{

  }

  getCatalogEumData =()=>{
    getCatalogEumAction().then(data=>{
      this.setState({ catalogData: data });
    });
  }

  getRowClassName = (record, index) => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys.findIndex(item => item === record.id) >= 0) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  }

  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  }

  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  }

  questStatistiscData = (param) => {
    let { factorId, evaluateId } = this.state;
    this.fetchControlMeasures(factorId, evaluateId);
  }

  fetchControlMeasures =(factorId,evaluateId)=>{
    getControlMeasAction(factorId,evaluateId).then(data=>{
      this.setState({ dataList: data });
    });
  }

  render() {
    const { pagination, dataList,totalCount,isChecked, selectedRowKeys,factorName,catalogData } = this.state;
    const defaultPageConfig = this.pageConfig;
    return (
      <div className='control-measures-root'>
        <div className='control-measures-header'>危险因素名称：{factorName}</div>
        <AmosGridTable
          columns={getColumns(catalogData)}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={totalCount}
          getTableDataAction={()=>{}}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowClick={this.onRowClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

ControlMeasures.propTypes = {
  factorName: PropTypes.string,
  factorId: PropTypes.number
};

export default ControlMeasures;
