import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Select, Input } from 'amos-framework';
import {
  getEquipmentOptionsDataAction,
  mgtCtrlEquipDetailAction,
  getRegionDepartmentTreeAction,
  getRiskSourceByTypeAction
} from '../../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;
const factorTypeEum = { 1: '设备设施危险因素', 2: '作业活动危险因素' };
const riskSourceType = '02';//区域
/**
 *
 * 关联安全管控对象内容
 * @class MgtCtrlEquip
 * @extends {Component}
 */
class MgtCtrlEquip extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        type: this.props.factorType,
        regionId: '',
        departmentId: '',
        workshopSection: '',
        controlObjectId: 0,
        controlObjectName: '',
        code: ''
      },
      rules: {
        regionId: [
          { required: true, message: '请输入所在分区' }
        ],
        departmentId: [
          { required: true,message: '请输入部门/车间' }
        ],
        workshopSection: [
          { required: true,message: '请输入所属工段' }
        ],
        controlObjectName: [
          { required: true,message: '请输入设备名称' }
        ],
        code: [
          { required: true,message: '请输入设备位号' }
        ]
      },
      areaData: [],
      deptData: [],
      stepData: [],
      equipData: [],
      positionData: [],
      factorIds: [],
      disabled: false,
      regionDepartmentTree: [],
      param: { regionId: '', departmentId: '', workshopSection: '', controlObjectName: '' }
    };
  }

  componentWillMount() {
    const { factorIds, factorId } = this.props;
    factorIds && this.setState({ factorIds });
    factorId && this.setState({ disabled: true, factorId });
  }

  componentDidMount() {
    this.getAreaData(riskSourceType);
    this.getDepartmentTreeData();
    const { factorId } = this.state;
    if (factorId) {
      this.getEditData(factorId);
    }
  }

  onSelectChange = (key, value, item) =>{
    const { form, param } = this.state;
    form[key] = value;
    if ('departmentId' === key) {
      this.getStepData(value);
      form.workshopSection = '';
      form.controlObjectName = '';
      form.code = '';
    } else if ('workshopSection' === key) {
      this.getEquipData(value);
      form.controlObjectName = '';
      form.code = '';
      param.workshopSection = value;
    } else if ('controlObjectId' === key) {
      this.getPositionData(item.optionName);
      form.controlObjectName = item.optionName;
      form.code = '';
    }
    this.setState({ form, param });
  };

  getEditData = (factorId) => {
    let { areaData } = this.state;
    areaData.length > 0 && this.getMgtCtrlEquipDetail(factorId);
  }

  getDepartmentTreeData = () => {
    getRegionDepartmentTreeAction().then(data => {
      let { factorId } = this.state;
      if (factorId) {
        this.getEditData(factorId);
      }
      this.setState({ regionDepartmentTree: data },()=>this.getDeptData());
    });
  }

  getAreaData = type => {
    getRiskSourceByTypeAction(type).then(data => {
      this.setState({ areaData: data });
    });
  }

  getDeptData = () => {
    let { regionDepartmentTree, deptData } = this.state;
    let depatData = regionDepartmentTree.secondDepartments;
    deptData = [];
    for (let key in depatData ) {
      depatData[key].map(item =>{
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        deptData.push(deptObj);
      });
    }
    this.setState({ deptData, chargerDeptData: deptData });
  }

  getStepData = (departmentId) => {
    let { param } = this.state;
    param.departmentId = departmentId;
    param.workshopSection = '';
    getEquipmentOptionsDataAction({ ...param, departmentId }).then(data => {
      this.setState({ stepData: data, param, equipData: [], positionData: [] });
    });
  }

  getEquipData = (workshopSection) => {
    let { param, factorId, form } = this.state;
    param.workshopSection = workshopSection;
    getEquipmentOptionsDataAction({ ...param, workshopSection }).then(data => {
      if (factorId) {//查看时
        let obj = data.filter(item => item.id === form.controlObjectId);
        if (obj.length === 1) {
          this.getPositionData(obj[0].optionName);
          form.controlObjectName = obj[0].optionName;
          this.setState({ form });
        }
      }
      this.setState({ equipData: data, param, positionData: [] });
    });
  };

  getPositionData = (controlObjectName) => {
    let { param, form } = this.state;
    getEquipmentOptionsDataAction({ ...param, controlObjectName }).then(data => {
      this.setState({ positionData: data, form });
    });
  };

  getMgtCtrlEquipDetail = factorId => {
    const { form } = this.state;
    mgtCtrlEquipDetailAction(factorId).then(data => {
      Object.assign(form, data);
      this.getDeptData(form.regionId);
      this.getStepData(form.departmentId);
      this.getEquipData(form.workshopSection);
      this.setState({ form });
    });
  };

  render() {
    const { form, rules, areaData, deptData, stepData, equipData, disabled, positionData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <Form model={form} rules={rules} ref={component =>this.form = component}>
        <FormItem label={<span>危险因素类型</span>} className='first-child-magin' field="type" {...formItemLayout}>
          <Input className="common-long-input" value={factorTypeEum[form.type]}  disabled />
        </FormItem>
        <FormItem label={<span>所属风险区域</span>} field="regionId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={areaData}
            disabled={disabled}
            value={form.regionId}
            renderOption={item => <Option value={String(item.id)}>{item.name}</Option>}
            onChange={e => this.onSelectChange('regionId', e)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="departmentId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={deptData}
            disabled={disabled}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={String(form.departmentId)}
            onChange={e => this.onSelectChange('departmentId', e)}
          />
        </FormItem>
        <FormItem label={<span>所属工段</span>} field="workshopSection" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={stepData}
            disabled={disabled}
            renderOption={item => <Option value={item.optionName}>{item.optionName}</Option>}
            value={form.workshopSection}
            onChange={e => this.onSelectChange('workshopSection', e)}
          />
        </FormItem>
        <FormItem label={<span>设备名称</span>} field="controlObjectId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={equipData}
            searchable
            disabled={disabled}
            value={form.controlObjectId}
            renderOption={item => <Option value={item.id}>{item.optionName}</Option>}
            onChange={(e, item) => this.onSelectChange('controlObjectId', e, item)}
          />
        </FormItem>
        <FormItem label={<span>设备位号</span>} field="code" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={positionData}
            searchable
            disabled={disabled}
            value={form.code}
            renderOption={item => <Option value={item.optionName}>{`${item.optionName}`}</Option>}
            onChange={(e, item) => this.onSelectChange('code', e, item)}
          />
        </FormItem>
      </Form>
    );
  }
}

MgtCtrlEquip.propTypes = {
  type: PropTypes.string,
  factorIds: PropTypes.array,
  factorId: PropTypes.string
};

export default MgtCtrlEquip;
