import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Select, Input, InputNumber } from 'amos-framework';
import {
  getRegionDepartmentTreeAction,
  getTaskworkUnPageAction,
  getTaskworkDetailAction,
  getTaskworkContentDetailAction,
  getRiskSourceByTypeAction
 } from '../../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;
const riskSourceType = '02';//区域
const factorTypeEum = { 1: '设备设施危险因素',2: '作业活动危险因素' };
/**
 *
 * 关联安全管控对象内容
 * @class MgtCtrlTaskwork
 * @extends {Component}
 */
class MgtCtrlTaskwork extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        type: this.props.factorType,
        regionId: '',
        departmentId: '',
        groupId: '',
        taskworkId: '',
        post: '',
        part: '',
        controlObjectId: '',
        serialNum: '',
        controlObjectName: ''
      },
      rules: {
        controlObjectId: [
          { required: true,message: '请输入作业活动步骤' }
        ]
      },
      deptData: [],
      regionData: [],
      groupData: [],
      regionDepartmentTree: [],
      searchParam: [],
      disabled: false,
      taskworkContentData: []
    };

  }

  componentWillMount() {
    const { factorIds,controlObjectId } = this.props;
    factorIds && this.setState({ factorIds });//绑定
    controlObjectId && this.setState({ disabled: true,controlObjectId });//查看绑定
  }

  componentDidMount() {
    this.getAreaData(riskSourceType);
    this.getDepartmentTreeData();
  }

  onSelectChange = (key, value,e) => {
    const { form, searchParam } = this.state;
    form[key] = value;
    if (key === 'regionId') {
      let param = searchParam.filter(item=>item.name !== key);
      param.push({ name: key,value,type: '' });
      this.setState({ searchParam: param },()=>this.getTaskWorkListData());
    }
    if (key === 'departmentId') {
      this.getTeamData(value);
      let param = searchParam.filter(item=>item.name !== key);
      param.push({ name: key,value,type: '' });
      this.setState({ searchParam: param },()=>this.getTaskWorkListData());
    }
    if (key === 'groupId') {
      let param = searchParam.filter(item=>item.name !== key);
      param.push({ name: key,value,type: '' });
      this.setState({ searchParam: param },()=>this.getTaskWorkListData());
    }
    if (key === 'taskworkId') {
      this.getTaskWorkDetail(value);
    }
    if (key === 'controlObjectId') {
      form.serialNum = e.serialNum;
      form.controlObjectName = e.content;
    }
    this.setState({ form });
  }

  getMgtCtrlObjById =(controlObjectId)=>{
    getTaskworkContentDetailAction(controlObjectId).then(data=>{
      const { form } = this.state;
      let { contentList = [] } = data;
      form.regionId = data.regionId;
      form.departmentId = data.departmentId;
      form.groupId = data.groupId;
      form.taskworkId = data.id;
      form.post = data.post;
      form.part = data.part;
      form.controlObjectId = controlObjectId;
      form.serialNum = contentList.length > 0 ? contentList[0].serialNum : '';
      this.getTeamData(data.departmentId);
      this.getTaskWorkDetail(data.id);
      this.setState({ form });
    });
  }

  getDepartmentTreeData = () => {
    getRegionDepartmentTreeAction().then(data => {
      this.setState({ regionDepartmentTree: data },()=>{
        this.getDeptData();
        this.forEditUse();
      });
    });
  }

  getAreaData = type => {
    getRiskSourceByTypeAction(type).then(data => {
      this.setState({ regionData: data });
    });
  }

  getDeptData = () => {
    let { regionDepartmentTree, deptData } = this.state;
    let depatData = regionDepartmentTree.secondDepartments;
    deptData = [];
    for (let key in depatData ) {
      depatData[key].map(item =>{
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        deptData.push(deptObj);
      });
    }
    this.setState({ deptData, chargerDeptData: deptData });
  }

  getTaskWorkDetail = taskworkId => {
    getTaskworkDetailAction(taskworkId).then(data => {
      let { form,taskworkContentData } = this.state;
      form.post = data.post;
      form.part = data.part;
      taskworkContentData = data.contentList;
      this.setState({ form,taskworkContentData });
    });
  };

  //获取班组
  getTeamData = (departmentId) => {
    let { regionDepartmentTree, groupData } = this.state;
    let depatData = regionDepartmentTree.thirdDepartments;
    let dData  = new Map(Object.entries(depatData)).get(String(departmentId));
    groupData = [];
    dData && dData.map(item => {
      let deptObj = {};
      deptObj.id = item.sequenceNbr;
      deptObj.name = item.departmentName;
      groupData.push(deptObj);
    });
    this.setState({ groupData });
  };

  getTaskWorkListData = () => {
    const { searchParam } = this.state;
    getTaskworkUnPageAction(searchParam).then(data => {
      this.setState({
        taskworkData: data
      });
    });
  };

  forEditUse = () => {
    const { controlObjectId } = this.state;
    if (controlObjectId) {//查看
      this.getTaskWorkListData();
      this.getMgtCtrlObjById(controlObjectId);
    }
  }

  render() {
    const { form,rules,deptData,regionData,groupData,disabled,taskworkData = [],taskworkContentData = [] } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <Form model={form} rules={rules} ref={component =>this.form = component}>
        <FormItem label={<span>危险因素类型</span>}  className='first-child-magin' field="type" {...formItemLayout}>
          <Input className="common-long-input" value={factorTypeEum[form.type]}  disabled />
        </FormItem>
        <FormItem label={<span>所属风险区域</span>} field="regionId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={regionData}
            disabled={disabled}
            value={form.regionId}
            renderOption={item => <Option value={String(item.id)}>{item.name}</Option>}
            onChange={e => this.onSelectChange('regionId', e)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="departmentId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={deptData}
            disabled={disabled}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.departmentId}
            onChange={e => this.onSelectChange('departmentId', e)}
          />
        </FormItem>
        <FormItem label={<span>班组</span>} field="groupId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={groupData}
            disabled={disabled}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.groupId}
            onChange={e => this.onSelectChange('groupId', e)}
          />
        </FormItem>
        <FormItem label={<span>作业活动名称</span>} field="taskworkId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={taskworkData}
            disabled={disabled}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.taskworkId}
            onChange={e => this.onSelectChange('taskworkId', e)}
          />
        </FormItem>
        <FormItem label={<span>作业活动岗位</span>} field="post" {...formItemLayout}>
          <Input className="common-long-input"  value={form.post}  disabled />
        </FormItem>
        <FormItem label={<span>作业活动部位</span>} field="part" {...formItemLayout}>
          <Input className="common-long-input"  value={form.part}  disabled />
        </FormItem>
        <FormItem label={<span>作业活动步骤</span>} field="controlObjectId" {...formItemLayout}>
          <Select
            className="common-long-select"
            data={taskworkContentData}
            disabled={disabled}
            renderOption={item => <Option value={item.id}>{item.content}</Option>}
            value={form.controlObjectId}
            onChange={(e,item) => this.onSelectChange('controlObjectId', e,item)}
          />
        </FormItem>
        <FormItem label={<span>步骤顺序</span>} field="serialNum" {...formItemLayout}>
          <InputNumber value={form.serialNum}  disabled />
        </FormItem>
      </Form>
    );
  }
}

MgtCtrlTaskwork.propTypes = {
  factorType: PropTypes.string,
  factorIds: PropTypes.array,
  controlObjectId: PropTypes.number
};

export default MgtCtrlTaskwork;
