import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form,Input,Select } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 *
 * 摄像头编辑新增
 * @class CamerasEdit
 * @extends {Component}
 */
class CamerasEdit extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        id: '',
        name: '',
        type: '',
        code: '',
        ip: '',
        username: '',
        password: '',
        port: '',
        channel: ''
      },
      rules: {
        type: [
          { required: true,message: '请输入摄像机类型' }
        ],
        name: [
          { required: true,message: '请输入摄像机名称' }
        ],
        code: [
          { required: true,message: '请输入摄像机编号' }
        ],
        ip: [
          { required: true,message: '请输入摄像机IP' }
        ],
        username: [
          { required: true,message: '请输入用户名' }
        ],
        password: [
          { required: true,message: '请输入密码' }
        ],
        port: [
          { required: true,message: '请输入端口号' }
        ],
        channel: [
          { required: true,message: '请输入通道' }
        ]
      }
    };
  }

  componentWillMount() {
    const { selectedRow } = this.props;
    if (selectedRow) {
      this.setState({ form: selectedRow });
    }
  }

  componentDidMount() {

  }

  onSelectChange = (key, e) => {
    let { form } = this.state;
    form[key] = e;
    this.setState({ form });
  }

  render() {
    const { form, rules } = this.state;
    const { camerasTypeData = [] } = this.props;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 5 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form model={form} className='cameras-form' rules={rules} ref={component =>this.form = component}>
        <FormItem label={<span>摄像机编号</span>} field="code" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.code}  onChange={(e) => this.onSelectChange('code',e.target.value)} />
        </FormItem>
        <FormItem label={<span>摄像机名称</span>} field="name" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.name}  onChange={(e) => this.onSelectChange('name',e.target.value)} />
        </FormItem>
        <FormItem label={<span>摄像机类型</span>} field="type" {...formItemLayout}>
          <Select
            className="cameras-form-select"
            data={camerasTypeData}
            renderOption={item => <Option value={item.code}>{item.name}</Option>}
            value={form.type}
            onChange={value => this.onSelectChange('type', value)}
          />
        </FormItem>
        <FormItem label={<span>摄像机IP</span>} field="ip" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.ip}  onChange={(e) => this.onSelectChange('ip',e.target.value)} />
        </FormItem>
        <FormItem label={<span>用户名</span>} field="username" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.username}  onChange={(e) => this.onSelectChange('username',e.target.value)} />
        </FormItem>
        <FormItem label={<span>密码</span>} field="password" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.password}  onChange={(e) => this.onSelectChange('password',e.target.value)} />
        </FormItem>
        <FormItem label={<span>端口号</span>} field="port" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.port}  onChange={(e) => this.onSelectChange('port',e.target.value)} />
        </FormItem>
        <FormItem label={<span>通道</span>} field="channel" {...formItemLayout}>
          <Input placeholder="请输入" className='cameras-form-input' value={form.channel}  onChange={(e) => this.onSelectChange('channel',e.target.value)} />
        </FormItem>
      </Form>
    );
  }
}

CamerasEdit.propTypes = {
  selectedRow: PropTypes.object,
  camerasTypeData: PropTypes.arry
};

export default CamerasEdit;
