import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Select,Button } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 设备设施摄像机查询页面
 *
 * @class EquipCameraSearch
 * @extends {Component}
 */
class EquipCameraSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      typeData: [],
      form: {
        code: {//摄像机编号
          name: 'code',
          type: 'LIKE',
          value: ''
        },
        name: {//摄像机名称
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        type: {//摄像机类别
          name: 'type',
          value: ''
        },
        ip: {//摄像机ip
          name: 'ip',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }

  componentDidMount() {

  }

  componentWillReceiveProps(nextProps) {

  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange(key, value) {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  }

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.search(form);
  }
  render() {
    const { form, typeData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 9 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 7 }
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0px' }} className="point-search" model={form}>
        <FormItem label={<span>摄像机类型</span>} field="type" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={typeData || []}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            value={form.type.value}
            onChange={e => this.onSelectChange('type', e)}
          />
        </FormItem>
        <FormItem label={<span>摄像机编号</span>} field="code" {...formItemLayout}>
          <Input value={form.code.value} className="search_Input" onChange={e => this.onChange('code', e)} />
        </FormItem>
        <FormItem label={<span>摄像机名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>摄像机IP</span>} field="ip" {...formItemLayout}>
          <Input value={form.ip.value} className="search_Input" onChange={e => this.onChange('ip', e)} />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} style={{ background: '#19afff' }}>查询</Button>
          <Button  style={{ background: 'transparent', marginLeft: '0.8rem !important', color: 'black' }} onClick={this.initFormValues}>重置</Button>
        </FormItem>
      </Form>
    );
  }
}

EquipCameraSearch.propTypes = {
  search: PropTypes.func
};

export default EquipCameraSearch;
