import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Select } from 'amos-framework';
import { getRiskSourceByTypeAction } from './../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;
const riskSourceType = '02';//风险区域
/**
 * 作业活动查询页面
 *
 * @class TaskWorkSearch
 * @extends {Component}
 */
class TaskWorkSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        dept: {//部门id
          name: 'departmentId',
          value: ''
        },
        region: {//所在分区
          name: 'regionId',
          value: ''
        },
        group: {//所在班组
          name: 'groupId',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        post: {
          name: 'post',
          type: 'LIKE',
          value: ''
        },
        part: {
          name: 'part',
          type: 'LIKE',
          value: ''
        },
        status: {
          name: 'status',
          value: ''
        },
        isMonitor: {
          name: 'isMonitor',
          value: ''
        },
        type: {
          name: 'type',
          value: ''
        }
      },
      regionData: [],
      deptData: [],
      groupData: [],
      regionDepartmentTree: {},
      statusData:[    //状态搜索
        { id: "0" , name: "未流程中" },
        { id: "7" , name: "流程中" },
      ]
    };
  }

  componentDidMount(){
    this.getRiskSource(riskSourceType);
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.regionDepartmentTree !== nextProps.regionDepartmentTree) {
      this.setState({ regionDepartmentTree: nextProps.regionDepartmentTree }, ()=>this.getDeptData());
    }
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange(key, value) {
    const { form } = this.state;
    form[key].value = value;
    if (key === 'region') {//获取分区下部门
      this.getDeptData(value);
      form['dept'].value = '';
      form['group'].value = '';
    }
    if (key === 'dept') {
      this.getTeamData(value);
      form['group'].value = '';
    }
    this.setState({ form });
  }

  onInitForm = () => {
    let { form } = this.state;
    for (let k in form) {
      form[k].value = '';
    }
    this.setState({ form });
  }

  //获取分区
  getRiskSource = type => {
    getRiskSourceByTypeAction(type).then(data => {
      this.setState({ regionData: data });
    });
  }

  //获取部门
  getDeptData = () => {
    let { regionDepartmentTree, deptData } = this.state;
    let depatData = regionDepartmentTree.secondDepartments;
    deptData = [];
    for (let key in depatData ) {
      depatData[key].map(item =>{
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        deptData.push(deptObj);
      });
    }
    this.setState({ deptData, chargerDeptData: deptData });
  };

  //获取班组
  getTeamData = (departmentId) => {
    const { regionDepartmentTree = [] } = this.state;
    let { groupData } = this.state;
    let depatData = regionDepartmentTree.thirdDepartments;
    let dData  = new Map(Object.entries(depatData)).get(String(departmentId));
    groupData = [];
    dData && dData.map(item => {
      let deptObj = {};
      deptObj.id = item.sequenceNbr;
      deptObj.name = item.departmentName;
      groupData.push(deptObj);
    });
    this.setState({ groupData });
  };

  render() {
    const { form, regionData, deptData, groupData, statusData } = this.state;
    const { typeData } = this.props;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 9 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0px' }} className="point-search" model={form}>
        <FormItem label={<span>所属风险区域</span>} field="region" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={regionData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.region.value}
            onChange={e => this.onSelectChange('region', e)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="dept" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={deptData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.dept.value}
            onChange={e => this.onSelectChange('dept', e)}
          />
        </FormItem>
        <FormItem label={<span>班组</span>} field="group" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={groupData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.group.value}
            onChange={e => this.onSelectChange('group', e)}
          />
        </FormItem>
        <FormItem label={<span>作业活动名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>作业活动岗位</span>} field="post" {...formItemLayout}>
          <Input value={form.post.value} className="search_Input" onChange={e => this.onChange('post', e)} />
        </FormItem>
        <FormItem label={<span>作业活动部位</span>} field="part" {...formItemLayout}>
          <Input value={form.part.value} className="search_Input" onChange={e => this.onChange('part', e)} />
        </FormItem>
        <FormItem label={<span>状态</span>} field="status" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={statusData || []}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            value={form.status.value}
            onChange={e => this.onSelectChange('status', e)}
          />
        </FormItem>
        <FormItem label={<span>作业活动类型</span>} field="type" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={typeData || []}
            renderOption={item => <Option value={item.dictDataKey}>{item.dictDataValue}</Option>}
            value={form.type.value}
            onChange={e => this.onSelectChange('type', e)}
          />
        </FormItem>
      </Form>
    );
  }
}

TaskWorkSearch.propTypes = {
  typeData: PropTypes.array,
  regionDepartmentTree: PropTypes.obj
};

export default TaskWorkSearch;
