import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Select } from 'amos-framework';
import { getCatalogEumAction, getTypeEumAction } from '../../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 管控措施查询页面
 *
 * @class ControlModelSearch
 * @extends {Component}
 */
class ControlModelSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        type: {
          name: 'type',
          type: 'EQUAL',
          value: ''
        },
        category: {
          name: 'category',
          type: 'EQUAL',
          value: ''
        }
      },
      catalogData: [],
      typeData: []
    };
  }

  componentDidMount() {
    this.getCatalogEumData();
    this.getTypeEumData();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange(key, value) {
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  getCatalogEumData = () => {
    getCatalogEumAction().then(data => {
      this.setState({ catalogData: data });
    });
  }

  getTypeEumData = () => {
    getTypeEumAction().then(data => {
      this.setState({ typeData: data });
    });
  }

  initSearchFileds = () => {
    let { form } = this.state;
    for (let k in form) {
      form[k].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form, catalogData, typeData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ width: 270, padding: '30px 0 0 0px', marginLeft: 'auto' }} className="point-search" model={form}>
        <FormItem label={<span>控制措施名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>控制措施类别</span>} field="category" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={catalogData || []}
            renderOption={item => <Option value={item.dictDataKey}>{item.dictDataValue}</Option>}
            value={form.category.value}
            onChange={e => this.onSelectChange('category', e)}
          />
        </FormItem>
        <FormItem label={<span>所属类型</span>} field="type" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={typeData || []}
            renderOption={item => <Option value={item.dictDataKey}>{item.dictDataValue}</Option>}
            value={form.type.value}
            onChange={e => this.onSelectChange('type', e)}
          />
        </FormItem>
      </Form>
    );
  }
}

ControlModelSearch.propTypes = {

};

export default ControlModelSearch;
